/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2008) by the Broad Institute/Massachusetts Institute
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
 */
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.broad.igv.data;

//~--- non-JDK imports --------------------------------------------------------
import java.util.Comparator;
import org.broad.igv.track.TrackType;

//~--- JDK imports ------------------------------------------------------------

import java.util.HashMap;
import java.util.Map;
import org.broad.igv.util.ArrayHeapSorter;

/**
 *
 * @author jrobinso
 */
public class WiggleDataset implements Dataset {

    String genome;
    private String name;
    private TrackProperties trackProperties;
    Map<String, IntArrayList> startLocationsMap = new HashMap();
    Map<String, IntArrayList> endLocationsMap = new HashMap();
    Map<String, FloatArrayList> dataMap = new HashMap();

    /**
     * Constructs ...
     *
     *
     * @param genomeId
     * @param name
     */
    public WiggleDataset(String genomeId, String name) {
        this.genome = genomeId;
        this.name = name;
        this.trackProperties = new TrackProperties();

    }

    public void sort() {

        for (String chr : startLocationsMap.keySet()) {
            final int[] starts = startLocationsMap.get(chr).toArray();
           
            int[] indeces = new int[starts.length];
            for (int i = 0; i < indeces.length; i++) {
                indeces[i] = i;
            }
            (new ArrayHeapSorter()).sort(indeces, new Comparator<Integer>() {

                public int compare(Integer arg0, Integer arg1) {
                    return starts[arg0] - starts[arg1];
                }
            });

            startLocationsMap.get(chr).reorder(indeces);
            endLocationsMap.get(chr).reorder(indeces);
            dataMap.get(chr).reorder(indeces);
        }

    }

    /**
     * Method description
     *
     *
     * @param chr
     * @param starts
     * @param ends
     * @param dataMap
     */
    public void addDataChunk(String chr, IntArrayList starts, IntArrayList ends,
            FloatArrayList data) {
        IntArrayList startLocations = this.startLocationsMap.get(chr);
        if (startLocations == null) {
            this.startLocationsMap.put(chr, starts);
        } else {
            startLocations.addAll(starts.toArray());
        }

        if (ends != null) {
            IntArrayList endLocations = this.endLocationsMap.get(chr);
            if (startLocations == null) {
                this.endLocationsMap.put(chr, ends);
            } else {
                endLocations.addAll(ends.toArray());
            }
        }

        FloatArrayList dataArray = this.dataMap.get(chr);
        if (dataArray == null) {
            this.dataMap.put(chr, data);
        } else {
            dataArray.addAll(data.toArray());
        }

    }

    // Todo -- implement
    /**
     * Method description
     *
     *
     * @return
     */
    public float getDataMin() {
        return 0f;
    }

    /**
     * Method description
     *
     *
     * @return
     */
    public float getDataMax() {
        return 10.0f;
    }

    /**
     * Method description
     *
     *
     * @return
     */
    public String getName() {
        return name;
    }

    /**
     * Method description
     *
     *
     * @return
     */
    public TrackType getType() {
        return TrackType.OTHER;
    }

    /**
     * Method description
     *
     *
     * @return
     */
    public String getGenome() {
        return genome;
    }

    /**
     * Method description
     *
     *
     * @return
     */
    public String[] getChromosomes() {
        return startLocationsMap.keySet().toArray(new String[]{});
    }

    /**
     * Method description
     *
     *
     * @return
     */
    public String[] getDataHeadings() {
        return new String[]{getName()};
    }

    /**
     * Method description
     *
     *
     * @param chr
     *
     * @return
     */
    public int[] getStartLocations(String chr) {
        IntArrayList startLocations = this.startLocationsMap.get(chr);
        return ((startLocations == null) ? null : startLocations.toArray());
    }

    /**
     * Method description
     *
     *
     * @param chr
     *
     * @return
     */
    public int[] getEndLocations(String chr) {
        IntArrayList endLocations = this.endLocationsMap.get(chr);
        return ((endLocations == null) ? null : endLocations.toArray());
    }

    /**
     * Method description
     *
     *
     * @param heading
     * @param chr
     *
     * @return
     */
    public float[] getData(String heading, String chr) {
        FloatArrayList data = this.dataMap.get(chr);
        return ((data == null) ? null : data.toArray());

    }

    /**
     * Method description
     *
     *
     * @param chr
     *
     * @return
     */
    public String[] getFeatureNames(String chr) {
        return null;
    }

    /**
     * Method description
     *
     *
     * @return
     */
    public int getWindowSpan() {
        return 1;
    }

    /**
     * Method description
     *
     *
     * @return
     */
    public boolean isLogNormalized() {
        return false;
    }

    /**
     * Method description
     *
     *
     * @return
     */
    public boolean isLogValues() {
        return false;
    }

    /**
     * Method description
     *
     *
     * @param name
     */
    public void setName(String name) {
        this.name = name;
    }

    public TrackProperties getTrackProperties() {
        return trackProperties;
    }

    public String getColorString() {
        return "0,0,255";
    }
}
