/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2008) by the Broad Institute/Massachusetts Institute 
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
*/

/*
 * Represents a complete dataset (startLocations, markers, data) for a single
 * chromosome.
 */
package org.broad.igv.data;

import java.util.HashMap;
import java.util.Map;

/**
 * Container for a block of data for a chromosome
 */
public class ChromosomeData {

    private String chr;

    private int[] startLocations;

    private int[] endLocations;

    private Map<String, float[]> data;

    ChromosomeData(String chr) {
        this.chr = chr;
        data = new HashMap();
    }

    void setStartLocations(int[] locations) {
        this.startLocations = locations;
    }

    int[] getStartLocations() {
        return startLocations;
    }

    void setData(String heading, float[] x) {
        data.put(heading, x);
    }

    float[] getData(String heading) {
        return data.get(heading);
    }

    public int[] getEndLocations() {
        return endLocations;
    }

    public void setEndLocations(int[] endLocations) {
        this.endLocations = endLocations;
    }
}
