/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools.util;

import java.io.IOException;
import java.io.InputStream;
import net.sf.samtools.util.LineReader;
import net.sf.samtools.util.RuntimeIOException;
import net.sf.samtools.util.StringUtil;

public class AsciiLineReader
implements LineReader {
    private static final byte LINEFEED = 10;
    private static final byte CARRIAGE_RETURN = 13;
    private final InputStream is;
    private byte[] buffer;
    private int nextChar;
    private int nChars;
    private byte[] lineBuffer = new byte[1000];
    private int lineNumber = 0;

    public AsciiLineReader(InputStream is) {
        this(is, 512000);
    }

    public AsciiLineReader(InputStream is, int bufferSize) {
        this.is = is;
        this.buffer = new byte[bufferSize];
        this.nChars = 0;
        this.nextChar = 0;
    }

    public String readLine() {
        return this.readLine(false);
    }

    public String readLine(boolean includeTerminators) {
        int linePosition = 0;
        while (this.nChars != -1) {
            byte b;
            if (this.nextChar == this.nChars) {
                this.fill();
                if (this.nextChar == this.nChars || this.nChars == -1) {
                    if (linePosition > 0) {
                        ++this.lineNumber;
                        return StringUtil.bytesToString(this.lineBuffer, 0, linePosition);
                    }
                    return null;
                }
            }
            if ((b = this.buffer[this.nextChar++]) == 10 || b == 13) {
                if (includeTerminators) {
                    this.lineBuffer[linePosition++] = b;
                    if (b == 13 && this.peek() == 10) {
                        this.lineBuffer[linePosition++] = b;
                        ++this.nextChar;
                    }
                } else if (b == 13 && this.peek() == 10) {
                    ++this.nextChar;
                }
                ++this.lineNumber;
                return StringUtil.bytesToString(this.lineBuffer, 0, linePosition);
            }
            if (linePosition > this.lineBuffer.length - 3) {
                byte[] temp = new byte[this.lineBuffer.length + 100];
                System.arraycopy(this.lineBuffer, 0, temp, 0, this.lineBuffer.length);
                this.lineBuffer = temp;
            }
            this.lineBuffer[linePosition++] = b;
        }
        return null;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int peek() {
        if (this.nextChar == this.nChars) {
            this.fill();
            if (this.nextChar == this.nChars) {
                return -1;
            }
        }
        return this.buffer[this.nextChar];
    }

    private void fill() {
        try {
            this.nChars = this.is.read(this.buffer);
            this.nextChar = 0;
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    public void close() {
        try {
            this.is.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

