/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools;

public class SAMValidationError {
    private final Type type;
    private final String message;
    private final String readName;
    private long recordNumber = -1L;

    public SAMValidationError(Type type, String message, String readName) {
        this.type = type;
        this.message = message;
        this.readName = readName;
    }

    public SAMValidationError(Type type, String message, String readName, long recordNumber) {
        this(type, message, readName);
        this.recordNumber = recordNumber;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.recordNumber > 0L) {
            builder.append("Record ").append(this.recordNumber).append(", ");
        }
        if (this.readName != null) {
            builder.append("Read name ").append(this.readName).append(", ");
        }
        return builder.append(this.message).toString();
    }

    public Type getType() {
        return this.type;
    }

    public String getMessage() {
        return this.message;
    }

    public String getReadName() {
        return this.readName;
    }

    public long getRecordNumber() {
        return this.recordNumber;
    }

    public void setRecordNumber(long recordNumber) {
        this.recordNumber = recordNumber;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        INVALID_FLAG_PROPER_PAIR,
        INVALID_FLAG_MATE_UNMAPPED,
        MISMATCH_FLAG_MATE_UNMAPPED,
        INVALID_FLAG_MATE_NEG_STRAND,
        MISMATCH_FLAG_MATE_NEG_STRAND,
        INVALID_FLAG_FIRST_OF_PAIR,
        INVALID_FLAG_SECOND_OF_PAIR,
        INVALID_FLAG_READ_NEG_STRAND,
        INVALID_FLAG_NOT_PRIM_ALIGNMENT,
        INVALID_FLAG_READ_UNMAPPED,
        INVALID_INSERT_SIZE,
        INVALID_MAPPING_QUALITY,
        INVALID_CIGAR,
        INVALID_MATE_REF_INDEX,
        MISMATCH_MATE_REF_INDEX,
        INVALID_REFERENCE_INDEX,
        INVALID_ALIGNMENT_START,
        MISMATCH_MATE_ALIGNMENT_START,
        MATE_FIELD_MISMATCH,
        INVALID_TAG_NM,
        MISSING_TAG_NM,
        MISSING_HEADER,
        MISSING_SEQUENCE_DICTIONARY,
        MISSING_READ_GROUP,
        RECORD_OUT_OF_ORDER,
        READ_GROUP_NOT_FOUND,
        INVALID_INDEXING_BIN;

    }
}

