/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools;

import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMFormatException;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMTextHeaderCodec;
import net.sf.samtools.SAMValidationError;
import net.sf.samtools.TextTagCodec;
import net.sf.samtools.util.AsciiLineReader;
import net.sf.samtools.util.CloseableIterator;
import net.sf.samtools.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SAMTextReader
extends SAMFileReader.ReaderImplementation {
    private static final int QNAME_COL = 0;
    private static final int FLAG_COL = 1;
    private static final int RNAME_COL = 2;
    private static final int POS_COL = 3;
    private static final int MAPQ_COL = 4;
    private static final int CIGAR_COL = 5;
    private static final int MRNM_COL = 6;
    private static final int MPOS_COL = 7;
    private static final int ISIZE_COL = 8;
    private static final int SEQ_COL = 9;
    private static final int QUAL_COL = 10;
    private static final int NUM_REQUIRED_FIELDS = 11;
    private static final Pattern VALID_BASES = Pattern.compile("^[acgtnACGTN.=]+$");
    private AsciiLineReader mReader;
    private SAMFileHeader mFileHeader = null;
    private String mCurrentLine = null;
    private RecordIterator mIterator = null;
    private File mFile = null;
    private final TextTagCodec tagCodec = new TextTagCodec();
    private SAMFileReader.ValidationStringency validationStringency = SAMFileReader.ValidationStringency.DEFAULT_STRINGENCY;

    SAMTextReader(InputStream stream) {
        this.mReader = new AsciiLineReader(stream);
        this.readHeader();
    }

    SAMTextReader(InputStream stream, File file) {
        this(stream);
        this.mFile = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void close() {
        if (this.mReader != null) {
            try {
                this.mReader.close();
            }
            finally {
                this.mReader = null;
            }
        }
    }

    @Override
    SAMFileHeader getFileHeader() {
        return this.mFileHeader;
    }

    @Override
    public SAMFileReader.ValidationStringency getValidationStringency() {
        return this.validationStringency;
    }

    @Override
    public void setValidationStringency(SAMFileReader.ValidationStringency stringency) {
        this.validationStringency = stringency;
    }

    @Override
    CloseableIterator<SAMRecord> getIterator() {
        if (this.mReader == null) {
            throw new IllegalStateException("File reader is closed");
        }
        if (this.mIterator != null) {
            throw new IllegalStateException("Iteration in progress");
        }
        this.mIterator = new RecordIterator();
        return this.mIterator;
    }

    @Override
    CloseableIterator<SAMRecord> query(String sequence, int start, int end, boolean contained) {
        throw new UnsupportedOperationException("Cannot query SAM text files");
    }

    private void readHeader() {
        SAMTextHeaderCodec headerCodec = new SAMTextHeaderCodec();
        this.mFileHeader = headerCodec.decode(this.mReader, this.mFile);
        this.advanceLine();
    }

    private String advanceLine() {
        this.mCurrentLine = this.mReader.readLine();
        return this.mCurrentLine;
    }

    private String makeErrorString(String reason) {
        String fileMessage = "";
        if (this.mFile != null) {
            fileMessage = "File " + this.mFile + "; ";
        }
        return "Error parsing text SAM file. " + reason + "; " + fileMessage + "Line " + this.mReader.getLineNumber() + "\nLine: " + this.mCurrentLine;
    }

    private RuntimeException reportFatalErrorParsingLine(String reason) {
        return new SAMFormatException(this.makeErrorString(reason));
    }

    private void reportErrorParsingLine(String reason) {
        String errorMessage = this.makeErrorString(reason);
        if (this.validationStringency == SAMFileReader.ValidationStringency.STRICT) {
            throw new SAMFormatException(errorMessage);
        }
        if (this.validationStringency == SAMFileReader.ValidationStringency.LENIENT) {
            System.err.println("Ignoring SAM validation error due to lenient parsing:");
            System.err.println(errorMessage);
        }
    }

    private void reportErrorParsingLine(Exception e) {
        String errorMessage = this.makeErrorString(e.getMessage());
        if (this.validationStringency == SAMFileReader.ValidationStringency.STRICT) {
            throw new SAMFormatException(errorMessage);
        }
        if (this.validationStringency == SAMFileReader.ValidationStringency.LENIENT) {
            System.err.println("Ignoring SAM validation error due to lenient parsing:");
            System.err.println(errorMessage);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RecordIterator
    implements CloseableIterator<SAMRecord> {
        private final String[] mFields = new String[10000];
        private SAMRecord mCurrentRecord;

        private RecordIterator() {
            assert (SAMTextReader.this.mReader != null);
            if (SAMTextReader.this.mCurrentLine != null) {
                this.parseLine();
            }
        }

        @Override
        public void close() {
            this.mCurrentRecord = null;
            SAMTextReader.this.close();
        }

        @Override
        public boolean hasNext() {
            return this.mCurrentRecord != null;
        }

        @Override
        public SAMRecord next() {
            if (!this.hasNext()) {
                throw new IllegalStateException("Cannot call next() on exhausted iterator");
            }
            SAMRecord ret = this.mCurrentRecord;
            this.mCurrentRecord = null;
            SAMTextReader.this.advanceLine();
            if (SAMTextReader.this.mCurrentLine != null) {
                this.parseLine();
            }
            return ret;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported: remove");
        }

        int parseInt(String s, String fieldName) {
            int ret;
            try {
                ret = Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                throw SAMTextReader.this.reportFatalErrorParsingLine("Non-numeric value in " + fieldName + " column");
            }
            return ret;
        }

        void validateReferenceName(String rname, String fieldName) {
            if (fieldName.equals("MRNM") && rname.equals("=")) {
                return;
            }
            if (SAMTextReader.this.getFileHeader().getSequenceDictionary().size() != 0 && SAMTextReader.this.getFileHeader().getSequence(rname) == null) {
                SAMTextReader.this.reportErrorParsingLine(fieldName + " '" + rname + "' not found in any SQ record");
            }
        }

        private void parseLine() {
            int numFields = StringUtil.split(SAMTextReader.this.mCurrentLine, this.mFields, '\t');
            if (numFields < 11) {
                SAMTextReader.this.reportErrorParsingLine("Not enough fields");
            }
            if (numFields == this.mFields.length) {
                SAMTextReader.this.reportErrorParsingLine("Too many fields in SAM text record.");
            }
            for (int i = 0; i < numFields; ++i) {
                if (this.mFields[i].length() != 0) continue;
                SAMTextReader.this.reportErrorParsingLine("Empty field at position " + i + " (zero-based)");
            }
            this.mCurrentRecord = new SAMRecord(SAMTextReader.this.mFileHeader);
            this.mCurrentRecord.setValidationStringency(SAMTextReader.this.getValidationStringency());
            this.mCurrentRecord.setHeader(SAMTextReader.this.mFileHeader);
            this.mCurrentRecord.setReadName(this.mFields[0]);
            int flags = this.parseInt(this.mFields[1], "FLAG");
            this.mCurrentRecord.setFlags(flags);
            String rname = this.mFields[2];
            if (!rname.equals("*")) {
                this.validateReferenceName(rname, "RNAME");
                this.mCurrentRecord.setReferenceName(rname);
            } else if (!this.mCurrentRecord.getReadUnmappedFlag()) {
                SAMTextReader.this.reportErrorParsingLine("RNAME is not specified but flags indicate mapped");
            }
            int pos = this.parseInt(this.mFields[3], "POS");
            int mapq = this.parseInt(this.mFields[4], "MAPQ");
            String cigar = this.mFields[5];
            if (!"*".equals(this.mCurrentRecord.getReferenceName())) {
                if (pos == 0) {
                    SAMTextReader.this.reportErrorParsingLine("POS must be non-zero if RNAME is specified");
                }
                if (!this.mCurrentRecord.getReadUnmappedFlag() && cigar.equals("*")) {
                    SAMTextReader.this.reportErrorParsingLine("CIGAR must not be '*' if RNAME is specified");
                }
            } else {
                if (pos != 0) {
                    SAMTextReader.this.reportErrorParsingLine("POS must be zero if RNAME is not specified");
                }
                if (mapq != 0) {
                    SAMTextReader.this.reportErrorParsingLine("MAPQ must be zero if RNAME is not specified");
                }
                if (!cigar.equals("*")) {
                    SAMTextReader.this.reportErrorParsingLine("CIGAR must be '*' if RNAME is not specified");
                }
            }
            this.mCurrentRecord.setAlignmentStart(pos);
            this.mCurrentRecord.setMappingQuality(mapq);
            this.mCurrentRecord.setCigarString(cigar);
            String mateRName = this.mFields[6];
            if (mateRName.equals("*")) {
                if (this.mCurrentRecord.getReadPairedFlag() && !this.mCurrentRecord.getMateUnmappedFlag()) {
                    SAMTextReader.this.reportErrorParsingLine("MRNM not specified but flags indicate mate mapped");
                }
            } else {
                if (!this.mCurrentRecord.getReadPairedFlag()) {
                    SAMTextReader.this.reportErrorParsingLine("MRNM specified but flags indicate unpaired");
                }
                this.validateReferenceName(mateRName, "MRNM");
                if (mateRName.equals("=")) {
                    if (this.mCurrentRecord.getReferenceName() == null) {
                        SAMTextReader.this.reportErrorParsingLine("MRNM is '=', but RNAME is not set");
                    }
                    this.mCurrentRecord.setMateReferenceName(this.mCurrentRecord.getReferenceName());
                } else {
                    this.mCurrentRecord.setMateReferenceName(mateRName);
                }
            }
            int matePos = this.parseInt(this.mFields[7], "MPOS");
            int isize = this.parseInt(this.mFields[8], "ISIZE");
            if (!this.mCurrentRecord.getMateReferenceName().equals("*")) {
                if (matePos == 0) {
                    SAMTextReader.this.reportErrorParsingLine("MPOS must be non-zero if MRNM is specified");
                }
            } else {
                if (matePos != 0) {
                    SAMTextReader.this.reportErrorParsingLine("MPOS must be zero if MRNM is not specified");
                }
                if (isize != 0) {
                    SAMTextReader.this.reportErrorParsingLine("ISIZE must be zero if MRNM is not specified");
                }
            }
            this.mCurrentRecord.setMateAlignmentStart(matePos);
            this.mCurrentRecord.setInferredInsertSize(isize);
            if (!this.mFields[9].equals("*")) {
                this.validateReadBases(this.mFields[9]);
                this.mCurrentRecord.setReadString(this.mFields[9]);
            }
            if (!this.mFields[10].equals("*")) {
                if (this.mCurrentRecord.getReadString() == null) {
                    SAMTextReader.this.reportErrorParsingLine("QUAL should not be specified if SEQ is not specified");
                }
                if (this.mCurrentRecord.getReadString().length() != this.mFields[10].length()) {
                    SAMTextReader.this.reportErrorParsingLine("length(QUAL) != length(SEQ)");
                }
                this.mCurrentRecord.setBaseQualityString(this.mFields[10]);
            }
            for (int i = 11; i < numFields; ++i) {
                this.parseTag(this.mFields[i]);
            }
            List<SAMValidationError> validationErrors = this.mCurrentRecord.isValid();
            if (validationErrors != null) {
                for (SAMValidationError errorMessage : validationErrors) {
                    SAMTextReader.this.reportErrorParsingLine(errorMessage.getMessage());
                }
            }
        }

        private void validateReadBases(String bases) {
            if (!VALID_BASES.matcher(bases).matches()) {
                SAMTextReader.this.reportErrorParsingLine("Invalid character in read bases");
            }
        }

        private void parseTag(String tag) {
            Map.Entry<String, Object> entry = null;
            try {
                entry = SAMTextReader.this.tagCodec.decode(tag);
            }
            catch (SAMFormatException e) {
                SAMTextReader.this.reportErrorParsingLine(e);
            }
            if (entry != null) {
                this.mCurrentRecord.setAttribute(entry.getKey(), entry.getValue());
            }
        }
    }
}

