/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.samtools.AbstractSAMHeaderRecord;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFormatException;
import net.sf.samtools.SAMProgramRecord;
import net.sf.samtools.SAMReadGroupRecord;
import net.sf.samtools.SAMSequenceDictionary;
import net.sf.samtools.SAMSequenceRecord;
import net.sf.samtools.TextTagCodec;
import net.sf.samtools.util.LineReader;
import net.sf.samtools.util.RuntimeIOException;
import net.sf.samtools.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SAMTextHeaderCodec {
    private static final String HEADER_LINE_START = "@";
    private SAMFileHeader mFileHeader;
    private final TextTagCodec mTagCodec = new TextTagCodec();
    private String mCurrentLine;
    private LineReader mReader;
    private File mFile;
    private List<SAMSequenceRecord> sequences;
    private List<SAMReadGroupRecord> readGroups;
    private BufferedWriter writer;
    private static final String TAG_KEY_VALUE_SEPARATOR = ":";
    private static final String FIELD_SEPARATOR = "\t";

    public SAMFileHeader decode(LineReader reader, File file) {
        this.mFileHeader = new SAMFileHeader();
        this.mReader = reader;
        this.mFile = file;
        this.sequences = new ArrayList<SAMSequenceRecord>();
        this.readGroups = new ArrayList<SAMReadGroupRecord>();
        block6: while (this.advanceLine() != null) {
            ParsedHeaderLine parsedHeaderLine = new ParsedHeaderLine(this.mCurrentLine);
            switch (parsedHeaderLine.getHeaderRecordType()) {
                case HD: {
                    this.parseHDLine(parsedHeaderLine);
                    continue block6;
                }
                case PG: {
                    this.parsePGLine(parsedHeaderLine);
                    continue block6;
                }
                case RG: {
                    this.parseRGLine(parsedHeaderLine);
                    continue block6;
                }
                case SQ: {
                    this.parseSQLine(parsedHeaderLine);
                    continue block6;
                }
            }
            throw new IllegalStateException("Unrecognized header record type: " + (Object)((Object)parsedHeaderLine.getHeaderRecordType()));
        }
        this.mFileHeader.setSequenceDictionary(new SAMSequenceDictionary(this.sequences));
        this.mFileHeader.setReadGroups(this.readGroups);
        return this.mFileHeader;
    }

    private String advanceLine() {
        int nextChar = this.mReader.peek();
        if (nextChar != 64) {
            return null;
        }
        this.mCurrentLine = this.mReader.readLine();
        return this.mCurrentLine;
    }

    private void transferAttributes(AbstractSAMHeaderRecord record, Map<String, String> textAttributes) {
        Object value;
        for (String string : record.getStandardTags()) {
            value = textAttributes.remove(string);
            if (value == null) continue;
            record.setAttribute(string, value);
        }
        for (Map.Entry entry : textAttributes.entrySet()) {
            value = this.mTagCodec.decodeTypeAndValue((String)entry.getValue());
            record.setAttribute((String)entry.getKey(), value);
        }
    }

    private void parsePGLine(ParsedHeaderLine parsedHeaderLine) {
        assert (HeaderRecordType.PG.equals((Object)parsedHeaderLine.getHeaderRecordType()));
        parsedHeaderLine.requireTag("ID");
        SAMProgramRecord programRecord = new SAMProgramRecord(parsedHeaderLine.removeValue("ID"));
        this.transferAttributes(programRecord, parsedHeaderLine.mKeyValuePairs);
        this.mFileHeader.addProgramRecord(programRecord);
    }

    private void parseRGLine(ParsedHeaderLine parsedHeaderLine) {
        assert (HeaderRecordType.RG.equals((Object)parsedHeaderLine.getHeaderRecordType()));
        parsedHeaderLine.requireTag("ID");
        parsedHeaderLine.requireTag("SM");
        SAMReadGroupRecord samReadGroupRecord = new SAMReadGroupRecord(parsedHeaderLine.removeValue("ID"));
        this.transferAttributes(samReadGroupRecord, parsedHeaderLine.mKeyValuePairs);
        String predictedMedianInsertSize = (String)samReadGroupRecord.getAttribute("PI");
        if (predictedMedianInsertSize != null) {
            try {
                samReadGroupRecord.setAttribute("PI", Integer.parseInt(predictedMedianInsertSize));
            }
            catch (NumberFormatException e) {
                throw new SAMFormatException("PI is not numeric: " + predictedMedianInsertSize, e);
            }
        }
        this.readGroups.add(samReadGroupRecord);
    }

    private void parseSQLine(ParsedHeaderLine parsedHeaderLine) {
        assert (HeaderRecordType.SQ.equals((Object)parsedHeaderLine.getHeaderRecordType()));
        parsedHeaderLine.requireTag("SN");
        parsedHeaderLine.requireTag("LN");
        SAMSequenceRecord samSequenceRecord = new SAMSequenceRecord(parsedHeaderLine.removeValue("SN"), Integer.parseInt(parsedHeaderLine.removeValue("LN")));
        this.transferAttributes(samSequenceRecord, parsedHeaderLine.mKeyValuePairs);
        this.sequences.add(samSequenceRecord);
    }

    private void parseHDLine(ParsedHeaderLine parsedHeaderLine) {
        assert (HeaderRecordType.HD.equals((Object)parsedHeaderLine.getHeaderRecordType()));
        parsedHeaderLine.requireTag("VN");
        this.transferAttributes(this.mFileHeader, parsedHeaderLine.mKeyValuePairs);
    }

    private RuntimeException reportErrorParsingLine(String reason) {
        String fileMessage = "";
        if (this.mFile != null) {
            fileMessage = "File " + this.mFile + "; ";
        }
        return new SAMFormatException("Error parsing text SAM file. " + reason + "; " + fileMessage + "Line " + this.mReader.getLineNumber() + "\nLine: " + this.mCurrentLine);
    }

    public void encode(Writer writer, SAMFileHeader header) {
        this.mFileHeader = header;
        this.writer = new BufferedWriter(writer);
        this.writeHDLine();
        for (SAMSequenceRecord sequenceRecord : header.getSequenceDictionary().getSequences()) {
            this.writeSQLine(sequenceRecord);
        }
        for (SAMReadGroupRecord readGroup : header.getReadGroups()) {
            this.writeRGLine(readGroup);
        }
        for (SAMProgramRecord programRecord : header.getProgramRecords()) {
            this.writePGLine(programRecord);
        }
        try {
            this.writer.flush();
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    private void println(String s) {
        try {
            this.writer.append(s);
            this.writer.append("\n");
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    private void writePGLine(SAMProgramRecord programRecord) {
        if (programRecord == null) {
            return;
        }
        String[] fields = new String[2 + programRecord.getAttributes().size()];
        fields[0] = HEADER_LINE_START + (Object)((Object)HeaderRecordType.PG);
        fields[1] = "ID:" + programRecord.getProgramGroupId();
        this.encodeTags(programRecord, fields, 2);
        this.println(StringUtil.join(FIELD_SEPARATOR, fields));
    }

    private void writeRGLine(SAMReadGroupRecord readGroup) {
        String[] fields = new String[2 + readGroup.getAttributes().size()];
        fields[0] = HEADER_LINE_START + (Object)((Object)HeaderRecordType.RG);
        fields[1] = "ID:" + readGroup.getReadGroupId();
        int i = 2;
        this.encodeTags(readGroup, fields, 2);
        this.println(StringUtil.join(FIELD_SEPARATOR, fields));
    }

    private void writeHDLine() {
        String[] fields = new String[1 + this.mFileHeader.getAttributes().size()];
        fields[0] = HEADER_LINE_START + (Object)((Object)HeaderRecordType.HD);
        this.encodeTags(this.mFileHeader, fields, 1);
        this.println(StringUtil.join(FIELD_SEPARATOR, fields));
    }

    private void writeSQLine(SAMSequenceRecord sequenceRecord) {
        int numAttributes = sequenceRecord.getAttributes() != null ? sequenceRecord.getAttributes().size() : 0;
        String[] fields = new String[3 + numAttributes];
        fields[0] = HEADER_LINE_START + (Object)((Object)HeaderRecordType.SQ);
        fields[1] = "SN:" + sequenceRecord.getSequenceName();
        fields[2] = "LN:" + Integer.toString(sequenceRecord.getSequenceLength());
        this.encodeTags(sequenceRecord, fields, 3);
        this.println(StringUtil.join(FIELD_SEPARATOR, fields));
    }

    private void encodeTags(AbstractSAMHeaderRecord rec, String[] fields, int offset) {
        for (Map.Entry<String, Object> entry : rec.getAttributes()) {
            String textTagRepresentation = rec.getStandardTags().contains(entry.getKey()) ? this.mTagCodec.encodeUntypedTag(entry.getKey(), entry.getValue()) : this.mTagCodec.encode(entry.getKey(), entry.getValue());
            fields[offset++] = textTagRepresentation;
        }
    }

    private class ParsedHeaderLine {
        private final HeaderRecordType mHeaderRecordType;
        private final Map<String, String> mKeyValuePairs = new HashMap<String, String>();

        ParsedHeaderLine(String line) {
            assert (line.startsWith(SAMTextHeaderCodec.HEADER_LINE_START));
            String[] fields = line.split(SAMTextHeaderCodec.FIELD_SEPARATOR);
            try {
                this.mHeaderRecordType = HeaderRecordType.valueOf(fields[0].substring(1));
            }
            catch (IllegalArgumentException e) {
                throw SAMTextHeaderCodec.this.reportErrorParsingLine("Unrecognized header record type");
            }
            for (int i = 1; i < fields.length; ++i) {
                String[] keyAndValue = fields[i].split(SAMTextHeaderCodec.TAG_KEY_VALUE_SEPARATOR, 2);
                if (keyAndValue.length != 2) {
                    throw SAMTextHeaderCodec.this.reportErrorParsingLine("Problem parsing @" + (Object)((Object)this.mHeaderRecordType) + " key:value pair");
                }
                this.mKeyValuePairs.put(keyAndValue[0], keyAndValue[1]);
            }
        }

        void requireTag(String tag) {
            if (!this.mKeyValuePairs.containsKey(tag)) {
                throw SAMTextHeaderCodec.this.reportErrorParsingLine(SAMTextHeaderCodec.HEADER_LINE_START + (Object)((Object)this.mHeaderRecordType) + " line missing " + tag + " tag");
            }
        }

        public HeaderRecordType getHeaderRecordType() {
            return this.mHeaderRecordType;
        }

        boolean containsKey(String key) {
            return this.mKeyValuePairs.containsKey(key);
        }

        String getValue(String key) {
            return this.mKeyValuePairs.get(key);
        }

        String removeValue(String key) {
            String ret = this.mKeyValuePairs.get(key);
            this.mKeyValuePairs.remove(key);
            return ret;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum HeaderRecordType {
        HD,
        SQ,
        RG,
        PG;

    }
}

