/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools;

import java.io.File;
import java.io.OutputStream;
import net.sf.samtools.BAMFileWriter;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileWriter;
import net.sf.samtools.SAMTextWriter;

public class SAMFileWriterFactory {
    public SAMFileWriter makeBAMWriter(SAMFileHeader header, boolean presorted, File outputFile) {
        BAMFileWriter ret = new BAMFileWriter(outputFile);
        ret.setSortOrder(header.getSortOrder(), presorted);
        ret.setHeader(header);
        return ret;
    }

    public SAMFileWriter makeBAMWriter(SAMFileHeader header, boolean presorted, File outputFile, int compressionLevel) {
        BAMFileWriter ret = new BAMFileWriter(outputFile, compressionLevel);
        ret.setSortOrder(header.getSortOrder(), presorted);
        ret.setHeader(header);
        return ret;
    }

    public SAMFileWriter makeSAMWriter(SAMFileHeader header, boolean presorted, File outputFile) {
        SAMTextWriter ret = new SAMTextWriter(outputFile);
        ret.setSortOrder(header.getSortOrder(), presorted);
        ret.setHeader(header);
        return ret;
    }

    public SAMFileWriter makeSAMWriter(SAMFileHeader header, boolean presorted, OutputStream stream) {
        SAMTextWriter ret = new SAMTextWriter(stream);
        ret.setSortOrder(header.getSortOrder(), presorted);
        ret.setHeader(header);
        return ret;
    }

    public SAMFileWriter makeSAMOrBAMWriter(SAMFileHeader header, boolean presorted, File outputFile) {
        String filename = outputFile.getName();
        if (filename.endsWith(".bam")) {
            return this.makeBAMWriter(header, presorted, outputFile);
        }
        if (filename.endsWith(".sam")) {
            return this.makeSAMWriter(header, presorted, outputFile);
        }
        throw new IllegalArgumentException("SAM/BAM file should end with .sam or .bam: " + outputFile);
    }
}

