/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import net.sf.samtools.BAMFileIndex;
import net.sf.samtools.BAMFileReader;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFormatException;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMTextReader;
import net.sf.samtools.util.BlockCompressedInputStream;
import net.sf.samtools.util.CloseableIterator;
import net.sf.samtools.util.IOUtil;
import net.sf.samtools.util.RuntimeIOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SAMFileReader
implements Iterable<SAMRecord> {
    private static ValidationStringency defaultValidationStringency = ValidationStringency.DEFAULT_STRINGENCY;
    private boolean mIsBinary = false;
    private BAMFileIndex mFileIndex = null;
    private ReaderImplementation mReader = null;

    public static ValidationStringency getDefaultValidationStringency() {
        return defaultValidationStringency;
    }

    public static void setDefaultValidationStringency(ValidationStringency defaultValidationStringency) {
        SAMFileReader.defaultValidationStringency = defaultValidationStringency;
    }

    public SAMFileReader(InputStream stream) {
        this(stream, false);
    }

    public SAMFileReader(File file) {
        this(file, null, false);
    }

    public SAMFileReader(File file, File indexFile) {
        this(file, indexFile, false);
    }

    public SAMFileReader(InputStream stream, boolean eagerDecode) {
        this.init(stream, eagerDecode);
    }

    public SAMFileReader(File file, boolean eagerDecode) {
        this.init(file, null, eagerDecode);
    }

    public SAMFileReader(File file, File indexFile, boolean eagerDecode) {
        this.init(file, indexFile, eagerDecode);
    }

    public void close() {
        if (this.mReader != null) {
            this.mReader.close();
        }
        if (this.mFileIndex != null) {
            this.mFileIndex.close();
        }
        this.mReader = null;
        this.mFileIndex = null;
    }

    public boolean isBinary() {
        return this.mIsBinary;
    }

    public boolean hasIndex() {
        return this.mFileIndex != null;
    }

    public SAMFileHeader getFileHeader() {
        return this.mReader.getFileHeader();
    }

    public void setValidationStringency(ValidationStringency validationStringency) {
        this.mReader.setValidationStringency(validationStringency);
    }

    @Override
    public CloseableIterator<SAMRecord> iterator() {
        return this.mReader.getIterator();
    }

    public CloseableIterator<SAMRecord> query(String sequence, int start, int end, boolean contained) {
        return this.mReader.query(sequence, start, end, contained);
    }

    public CloseableIterator<SAMRecord> queryOverlapping(String sequence, int start, int end) {
        return this.query(sequence, start, end, false);
    }

    public CloseableIterator<SAMRecord> queryContained(String sequence, int start, int end) {
        return this.query(sequence, start, end, true);
    }

    private void init(InputStream stream, boolean eagerDecode) {
        try {
            BufferedInputStream bufferedStream = IOUtil.toBufferedStream(stream);
            if (this.isBAMFile(bufferedStream)) {
                this.mIsBinary = true;
                this.mReader = new BAMFileReader(bufferedStream, eagerDecode);
            } else if (this.isGzippedSAMFile(bufferedStream)) {
                this.mIsBinary = false;
                this.mReader = new SAMTextReader(new GZIPInputStream(bufferedStream));
            } else if (this.isSAMFile(bufferedStream)) {
                this.mIsBinary = false;
                this.mReader = new SAMTextReader(bufferedStream);
            } else {
                throw new SAMFormatException("Unrecognized file format");
            }
            this.setValidationStringency(defaultValidationStringency);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    private void init(File file, File indexFile, boolean eagerDecode) {
        try {
            BufferedInputStream bufferedStream = new BufferedInputStream(new FileInputStream(file));
            if (this.isBAMFile(bufferedStream)) {
                bufferedStream.close();
                this.mIsBinary = true;
                BAMFileReader reader = new BAMFileReader(file, eagerDecode);
                this.mReader = reader;
                if (indexFile == null) {
                    indexFile = this.findIndexFile(file);
                }
                if (indexFile != null) {
                    this.mFileIndex = new BAMFileIndex(indexFile);
                    reader.setFileIndex(this.mFileIndex);
                }
            } else if (this.isGzippedSAMFile(bufferedStream)) {
                this.mIsBinary = false;
                this.mReader = new SAMTextReader(new GZIPInputStream(bufferedStream));
            } else if (this.isSAMFile(bufferedStream)) {
                if (indexFile != null) {
                    bufferedStream.close();
                    throw new RuntimeException("Cannot use index file with textual SAM file");
                }
                this.mIsBinary = false;
                this.mReader = new SAMTextReader(bufferedStream, file);
            } else {
                bufferedStream.close();
                throw new SAMFormatException("Unrecognized file format");
            }
            this.setValidationStringency(defaultValidationStringency);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    private File findIndexFile(File dataFile) {
        File indexFile;
        String bamExtension = ".bam";
        String fileName = dataFile.getName();
        if (fileName.endsWith(".bam")) {
            String bai = fileName.substring(0, fileName.length() - ".bam".length()) + ".bai";
            indexFile = new File(dataFile.getParent(), bai);
            if (indexFile.exists()) {
                return indexFile;
            }
        }
        if ((indexFile = new File(dataFile.getParent(), dataFile.getName() + ".bai")).exists()) {
            return indexFile;
        }
        return null;
    }

    private boolean isBAMFile(InputStream stream) throws IOException {
        return BlockCompressedInputStream.isValidFile(stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isGzippedSAMFile(BufferedInputStream stream) {
        if (!stream.markSupported()) {
            throw new IllegalArgumentException("Cannot test a stream that doesn't support marking.");
        }
        stream.mark(8000);
        try {
            GZIPInputStream gunzip = new GZIPInputStream(stream);
            int ch = gunzip.read();
            boolean bl = true;
            return bl;
        }
        catch (IOException ioe) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                stream.reset();
            }
            catch (IOException ioe) {
                throw new IllegalStateException("Could not reset stream.");
            }
        }
    }

    private boolean isSAMFile(InputStream stream) {
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class ReaderImplementation {
        ReaderImplementation() {
        }

        abstract SAMFileHeader getFileHeader();

        abstract CloseableIterator<SAMRecord> getIterator();

        abstract CloseableIterator<SAMRecord> query(String var1, int var2, int var3, boolean var4);

        abstract void close();

        abstract void setValidationStringency(ValidationStringency var1);

        abstract ValidationStringency getValidationStringency();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ValidationStringency {
        STRICT,
        LENIENT,
        SILENT;

        public static ValidationStringency DEFAULT_STRINGENCY;

        static {
            DEFAULT_STRINGENCY = STRICT;
        }
    }
}

