/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools;

import net.sf.samtools.SAMRecord;
import net.sf.samtools.util.CloseableIterator;
import net.sf.samtools.util.PeekIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotPrimarySkippingIterator {
    private final PeekIterator<SAMRecord> it;

    public NotPrimarySkippingIterator(CloseableIterator<SAMRecord> underlyingIt) {
        this.it = new PeekIterator<SAMRecord>(underlyingIt);
        this.skipAnyNotprimary();
    }

    public boolean hasCurrent() {
        return this.it.hasNext();
    }

    public SAMRecord getCurrent() {
        assert (this.hasCurrent());
        return this.it.peek();
    }

    public boolean advance() {
        this.it.next();
        this.skipAnyNotprimary();
        return this.hasCurrent();
    }

    private void skipAnyNotprimary() {
        while (this.it.hasNext() && this.it.peek().getNotPrimaryAlignmentFlag()) {
            this.it.next();
        }
    }
}

