/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sf.samtools.CigarElement;
import net.sf.samtools.CigarOperator;
import net.sf.samtools.SAMValidationError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Cigar {
    private final List<CigarElement> cigarElements = new ArrayList<CigarElement>();

    public Cigar() {
    }

    public Cigar(List<CigarElement> cigarElements) {
        this.cigarElements.addAll(cigarElements);
    }

    public List<CigarElement> getCigarElements() {
        return Collections.unmodifiableList(this.cigarElements);
    }

    public CigarElement getCigarElement(int i) {
        return this.cigarElements.get(i);
    }

    public void add(CigarElement cigarElement) {
        this.cigarElements.add(cigarElement);
    }

    public int numCigarElements() {
        return this.cigarElements.size();
    }

    public boolean isEmpty() {
        return this.cigarElements.isEmpty();
    }

    public int getReferenceLength() {
        int length = 0;
        for (CigarElement element : this.cigarElements) {
            switch (element.getOperator()) {
                case M: 
                case D: 
                case N: {
                    length += element.getLength();
                }
            }
        }
        return length;
    }

    public int getPaddedReferenceLength() {
        int length = 0;
        for (CigarElement element : this.cigarElements) {
            switch (element.getOperator()) {
                case M: 
                case D: 
                case N: 
                case P: {
                    length += element.getLength();
                }
            }
        }
        return length;
    }

    public List<SAMValidationError> isValid(String readName, long recordNumber) {
        if (this.isEmpty()) {
            return null;
        }
        ArrayList<SAMValidationError> ret = null;
        boolean seenRealOperator = false;
        for (int i = 0; i < this.cigarElements.size(); ++i) {
            CigarElement element = this.cigarElements.get(i);
            CigarOperator op = element.getOperator();
            if (Cigar.isClippingOperator(op)) {
                if (i == 0 || i == this.cigarElements.size() - 1) continue;
                if (ret == null) {
                    ret = new ArrayList();
                }
                ret.add(new SAMValidationError(SAMValidationError.Type.INVALID_CIGAR, "Clipping operator not at start or end of CIGAR", readName, recordNumber));
                continue;
            }
            if (Cigar.isRealOperator(op)) {
                seenRealOperator = true;
                if (!Cigar.isInDelOperator(op)) continue;
                for (int j = i + 1; j < this.cigarElements.size() && this.cigarElements.get(j).getOperator() != CigarOperator.M; ++j) {
                    if (!Cigar.isInDelOperator(this.cigarElements.get(j).getOperator())) continue;
                    if (ret == null) {
                        ret = new ArrayList();
                    }
                    ret.add(new SAMValidationError(SAMValidationError.Type.INVALID_CIGAR, "No M operator between pair of IDN operators in CIGAR", readName, recordNumber));
                }
                continue;
            }
            if (!Cigar.isPaddingOperator(op)) continue;
            if (i == 0 || i == this.cigarElements.size() - 1) {
                if (ret == null) {
                    ret = new ArrayList();
                }
                ret.add(new SAMValidationError(SAMValidationError.Type.INVALID_CIGAR, "Padding operator not valid at start or end of CIGAR", readName, recordNumber));
                continue;
            }
            if (Cigar.isRealOperator(this.cigarElements.get(i - 1).getOperator()) && Cigar.isRealOperator(this.cigarElements.get(i + 1).getOperator())) continue;
            if (ret == null) {
                ret = new ArrayList();
            }
            ret.add(new SAMValidationError(SAMValidationError.Type.INVALID_CIGAR, "Padding operator not between real operators in CIGAR", readName, recordNumber));
        }
        if (!seenRealOperator) {
            if (ret == null) {
                ret = new ArrayList<SAMValidationError>();
            }
            ret.add(new SAMValidationError(SAMValidationError.Type.INVALID_CIGAR, "No real operator (M|I|D|N) in CIGAR", readName, recordNumber));
        }
        return ret;
    }

    private static boolean isRealOperator(CigarOperator op) {
        return op == CigarOperator.M || op == CigarOperator.I || op == CigarOperator.D || op == CigarOperator.N;
    }

    private static boolean isInDelOperator(CigarOperator op) {
        return op == CigarOperator.I || op == CigarOperator.D || op == CigarOperator.N;
    }

    private static boolean isClippingOperator(CigarOperator op) {
        return op == CigarOperator.S || op == CigarOperator.H;
    }

    private static boolean isPaddingOperator(CigarOperator op) {
        return op == CigarOperator.P;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Cigar)) {
            return false;
        }
        Cigar cigar = (Cigar)o;
        return !(this.cigarElements != null ? !((Object)this.cigarElements).equals(cigar.cigarElements) : cigar.cigarElements != null);
    }

    public int hashCode() {
        return this.cigarElements != null ? ((Object)this.cigarElements).hashCode() : 0;
    }
}

