/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools;

import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sf.samtools.BAMFileConstants;
import net.sf.samtools.BAMFileIndex;
import net.sf.samtools.BAMRecordCodec;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMFormatException;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMSequenceDictionary;
import net.sf.samtools.SAMSequenceRecord;
import net.sf.samtools.SAMTextHeaderCodec;
import net.sf.samtools.SAMUtils;
import net.sf.samtools.SAMValidationError;
import net.sf.samtools.util.BinaryCodec;
import net.sf.samtools.util.BlockCompressedInputStream;
import net.sf.samtools.util.CloseableIterator;
import net.sf.samtools.util.StringLineReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BAMFileReader
extends SAMFileReader.ReaderImplementation {
    private boolean mIsSeekable = false;
    private BinaryCodec mStream = null;
    private final BlockCompressedInputStream mCompressedInputStream;
    private SAMFileHeader mFileHeader = null;
    private BAMFileIndex mFileIndex = null;
    private long mFirstRecordPointer = 0L;
    private CloseableIterator<SAMRecord> mCurrentIterator = null;
    private final boolean eagerDecode;
    private SAMFileReader.ValidationStringency mValidationStringency;

    BAMFileReader(InputStream stream, boolean eagerDecode) throws IOException {
        this.mIsSeekable = false;
        this.mCompressedInputStream = new BlockCompressedInputStream(stream);
        this.mStream = new BinaryCodec(new DataInputStream(this.mCompressedInputStream));
        this.eagerDecode = eagerDecode;
        this.readHeader(null);
    }

    BAMFileReader(File file, boolean eagerDecode) throws IOException {
        this.mIsSeekable = true;
        this.mCompressedInputStream = new BlockCompressedInputStream(file);
        this.mStream = new BinaryCodec(new DataInputStream(this.mCompressedInputStream));
        this.eagerDecode = eagerDecode;
        this.readHeader(file);
        this.mFirstRecordPointer = this.mCompressedInputStream.getFilePointer();
    }

    @Override
    void close() {
        if (this.mStream != null) {
            this.mStream.close();
        }
        this.mStream = null;
        this.mFileHeader = null;
        this.mFileIndex = null;
    }

    BAMFileIndex getFileIndex() {
        return this.mFileIndex;
    }

    void setFileIndex(BAMFileIndex fileIndex) {
        this.mFileIndex = fileIndex;
    }

    @Override
    SAMFileHeader getFileHeader() {
        return this.mFileHeader;
    }

    @Override
    void setValidationStringency(SAMFileReader.ValidationStringency validationStringency) {
        this.mValidationStringency = validationStringency;
    }

    @Override
    SAMFileReader.ValidationStringency getValidationStringency() {
        return this.mValidationStringency;
    }

    @Override
    CloseableIterator<SAMRecord> getIterator() {
        if (this.mStream == null) {
            throw new IllegalStateException("File reader is closed");
        }
        if (this.mCurrentIterator != null) {
            throw new IllegalStateException("Iteration in progress");
        }
        if (this.mIsSeekable) {
            try {
                this.mCompressedInputStream.seek(this.mFirstRecordPointer);
            }
            catch (IOException exc) {
                throw new RuntimeException(exc.getMessage(), exc);
            }
        }
        this.mCurrentIterator = new BAMFileIterator();
        return this.mCurrentIterator;
    }

    @Override
    CloseableIterator<SAMRecord> query(String sequence, int start, int end, boolean contained) {
        if (this.mStream == null) {
            throw new IllegalStateException("File reader is closed");
        }
        if (this.mCurrentIterator != null) {
            throw new IllegalStateException("Iteration in progress");
        }
        if (!this.mIsSeekable) {
            throw new UnsupportedOperationException("Cannot query stream-based BAM file");
        }
        if (this.mFileIndex == null) {
            throw new IllegalStateException("No BAM file index is available");
        }
        this.mCurrentIterator = new BAMFileIndexIterator(sequence, start, end, contained);
        return this.mCurrentIterator;
    }

    private void readHeader(File file) throws IOException {
        byte[] buffer = new byte[4];
        this.mStream.readBytes(buffer);
        if (!Arrays.equals(buffer, BAMFileConstants.BAM_MAGIC)) {
            throw new IOException("Invalid BAM file header");
        }
        int headerTextLength = this.mStream.readInt();
        String textHeader = this.mStream.readString(headerTextLength);
        this.mFileHeader = new SAMTextHeaderCodec().decode(new StringLineReader(textHeader), file);
        int sequenceCount = this.mStream.readInt();
        if (this.mFileHeader.getSequenceDictionary().size() > 0) {
            if (sequenceCount != this.mFileHeader.getSequenceDictionary().size()) {
                throw new SAMFormatException("Number of sequences in text header (" + this.mFileHeader.getSequenceDictionary().size() + ") != number of sequences in binary header (" + sequenceCount + ") for file " + file);
            }
            for (int i = 0; i < sequenceCount; ++i) {
                SAMSequenceRecord binarySequenceRecord = this.readSequenceRecord(file);
                SAMSequenceRecord sequenceRecord = this.mFileHeader.getSequence(i);
                if (!sequenceRecord.getSequenceName().equals(binarySequenceRecord.getSequenceName())) {
                    throw new SAMFormatException("For sequence " + i + ", text and binary have different names in file " + file);
                }
                if (sequenceRecord.getSequenceLength() == binarySequenceRecord.getSequenceLength()) continue;
                throw new SAMFormatException("For sequence " + i + ", text and binary have different lengths in file " + file);
            }
        } else {
            ArrayList<SAMSequenceRecord> sequences = new ArrayList<SAMSequenceRecord>(sequenceCount);
            for (int i = 0; i < sequenceCount; ++i) {
                sequences.add(this.readSequenceRecord(file));
            }
            this.mFileHeader.setSequenceDictionary(new SAMSequenceDictionary(sequences));
        }
    }

    private SAMSequenceRecord readSequenceRecord(File file) {
        int nameLength = this.mStream.readInt();
        if (nameLength <= 1) {
            throw new SAMFormatException("Invalid BAM file header: missing sequence name in file " + file);
        }
        String sequenceName = this.mStream.readString(nameLength - 1);
        this.mStream.readByte();
        int sequenceLength = this.mStream.readInt();
        return new SAMSequenceRecord(sequenceName, sequenceLength);
    }

    private class BAMFileIndexIterator
    extends BAMFileIterator {
        private long[] mFilePointers;
        private int mFilePointerIndex;
        private long mFilePointerLimit;
        private int mReferenceIndex;
        private int mRegionStart;
        private int mRegionEnd;
        private boolean mReturnContained;

        BAMFileIndexIterator(String sequence, int start, int end, boolean contained) {
            super(false);
            this.mFilePointers = null;
            this.mFilePointerIndex = 0;
            this.mFilePointerLimit = -1L;
            this.mReferenceIndex = -1;
            this.mRegionStart = 0;
            this.mRegionEnd = 0;
            this.mReturnContained = false;
            SAMFileHeader fileHeader = BAMFileReader.this.getFileHeader();
            this.mReferenceIndex = fileHeader.getSequenceIndex(sequence);
            if (this.mReferenceIndex != -1) {
                BAMFileIndex fileIndex = BAMFileReader.this.getFileIndex();
                this.mFilePointers = fileIndex.getSearchBins(this.mReferenceIndex, start, end);
            }
            this.mRegionStart = start;
            this.mRegionEnd = end <= 0 ? Integer.MAX_VALUE : end;
            this.mReturnContained = contained;
            this.advance();
        }

        SAMRecord getNextRecord() throws IOException {
            SAMRecord record;
            while (true) {
                if (BAMFileReader.this.mCompressedInputStream.getFilePointer() >= this.mFilePointerLimit) {
                    if (this.mFilePointers == null || this.mFilePointerIndex >= this.mFilePointers.length) {
                        return null;
                    }
                    long startOffset = this.mFilePointers[this.mFilePointerIndex++];
                    long endOffset = this.mFilePointers[this.mFilePointerIndex++];
                    BAMFileReader.this.mCompressedInputStream.seek(startOffset);
                    this.mFilePointerLimit = endOffset;
                    continue;
                }
                record = super.getNextRecord();
                if (record == null) {
                    return null;
                }
                int referenceIndex = record.getReferenceIndex();
                if (referenceIndex != this.mReferenceIndex) {
                    if (referenceIndex >= 0 && referenceIndex <= this.mReferenceIndex) continue;
                    this.mFilePointers = null;
                    return null;
                }
                if (this.mRegionStart == 0 && this.mRegionEnd == Integer.MAX_VALUE) {
                    return record;
                }
                int alignmentStart = record.getAlignmentStart();
                int alignmentEnd = record.getAlignmentEnd();
                if (alignmentStart > this.mRegionEnd) {
                    this.mFilePointers = null;
                    return null;
                }
                if (this.mReturnContained ? alignmentStart >= this.mRegionStart && alignmentEnd <= this.mRegionEnd : alignmentEnd >= this.mRegionStart && alignmentStart <= this.mRegionEnd) break;
            }
            return record;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BAMFileIterator
    implements CloseableIterator<SAMRecord> {
        private SAMRecord mNextRecord = null;
        private final BAMRecordCodec bamRecordCodec = new BAMRecordCodec(BAMFileReader.this.getFileHeader());
        private long samRecordIndex = 0L;

        BAMFileIterator() {
            this(true);
        }

        BAMFileIterator(boolean advance) {
            this.bamRecordCodec.setInputStream(BAMFileReader.this.mStream.getInputStream());
            if (advance) {
                this.advance();
            }
        }

        @Override
        public void close() {
            if (this != BAMFileReader.this.mCurrentIterator) {
                throw new IllegalStateException("Attempt to close non-current iterator");
            }
            BAMFileReader.this.mCurrentIterator = null;
        }

        @Override
        public boolean hasNext() {
            return this.mNextRecord != null;
        }

        @Override
        public SAMRecord next() {
            SAMRecord result = this.mNextRecord;
            this.advance();
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported: remove");
        }

        void advance() {
            try {
                this.mNextRecord = this.getNextRecord();
                if (this.mNextRecord != null) {
                    ++this.samRecordIndex;
                    this.mNextRecord.setValidationStringency(BAMFileReader.this.mValidationStringency);
                    if (BAMFileReader.this.mValidationStringency != SAMFileReader.ValidationStringency.SILENT) {
                        List<SAMValidationError> validationErrors = this.mNextRecord.isValid();
                        SAMUtils.processValidationErrors(validationErrors, this.samRecordIndex, BAMFileReader.this.getValidationStringency());
                    }
                }
                if (BAMFileReader.this.eagerDecode && this.mNextRecord != null) {
                    this.mNextRecord.eagerDecode();
                }
            }
            catch (IOException exc) {
                throw new RuntimeException(exc.getMessage(), exc);
            }
        }

        SAMRecord getNextRecord() throws IOException {
            return this.bamRecordCodec.decode();
        }
    }
}

