/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import net.sf.samtools.BAMFileConstants;
import net.sf.samtools.util.RuntimeIOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BAMFileIndex {
    private static final int MAX_BINS = 37450;
    private static final int BAM_LIDX_SHIFT = 16;
    private File mFile = null;
    private FileInputStream mFileStream = null;
    private FileChannel mFileChannel = null;
    private MappedByteBuffer mFileBuffer = null;

    BAMFileIndex(File file) {
        this.mFile = file;
    }

    void close() {
        this.closeFileStream();
    }

    long[] getSearchBins(int referenceIndex, int startPos, int endPos) {
        int nChunks;
        this.openIndex();
        this.seek(4);
        int sequenceCount = this.readInteger();
        if (referenceIndex >= sequenceCount) {
            return null;
        }
        BitSet regionBins = this.regionToBins(startPos, endPos);
        if (regionBins == null) {
            return null;
        }
        for (int i = 0; i < referenceIndex; ++i) {
            int nBins = this.readInteger();
            for (int j = 0; j < nBins; ++j) {
                int bin = this.readInteger();
                nChunks = this.readInteger();
                this.skipBytes(16 * nChunks);
            }
            int nLinearBins = this.readInteger();
            this.skipBytes(8 * nLinearBins);
        }
        int nIndexBins = this.readInteger();
        if (nIndexBins == 0) {
            return null;
        }
        List<Chunk> chunkList = new ArrayList<Chunk>();
        for (int i = 0; i < nIndexBins; ++i) {
            int indexBin = this.readInteger();
            nChunks = this.readInteger();
            if (regionBins.get(indexBin)) {
                for (int ci = 0; ci < nChunks; ++ci) {
                    long chunkBegin = this.readLong();
                    long chunkEnd = this.readLong();
                    chunkList.add(new Chunk(chunkBegin, chunkEnd));
                }
                continue;
            }
            this.skipBytes(16 * nChunks);
        }
        if (chunkList.isEmpty()) {
            return null;
        }
        int start = startPos <= 0 ? 0 : startPos - 1;
        int regionLinearBin = start >> 16;
        int nLinearBins = this.readInteger();
        long minimumOffset = 0L;
        if (regionLinearBin < nLinearBins) {
            this.skipBytes(8 * regionLinearBin);
            minimumOffset = this.readLong();
        }
        chunkList = this.optimizeChunkList(chunkList, minimumOffset);
        return this.convertToArray(chunkList);
    }

    private List<Chunk> optimizeChunkList(List<Chunk> chunkList, long minimumOffset) {
        Chunk lastChunk = null;
        Collections.sort(chunkList);
        ArrayList<Chunk> result = new ArrayList<Chunk>();
        for (Chunk chunk : chunkList) {
            if (chunk.getChunkEnd() <= minimumOffset) continue;
            if (result.isEmpty()) {
                result.add(chunk);
                lastChunk = chunk;
                continue;
            }
            long lastFileBlock = this.getFileBlock(lastChunk.getChunkEnd());
            long chunkFileBlock = this.getFileBlock(chunk.getChunkStart());
            if (chunkFileBlock - lastFileBlock > 1L) {
                result.add(chunk);
                lastChunk = chunk;
                continue;
            }
            if (chunk.getChunkEnd() <= lastChunk.getChunkEnd()) continue;
            lastChunk.setChunkEnd(chunk.getChunkEnd());
        }
        return result;
    }

    private long[] convertToArray(List<Chunk> chunkList) {
        int count = chunkList.size() * 2;
        if (count == 0) {
            return null;
        }
        int index = 0;
        long[] result = new long[count];
        for (Chunk chunk : chunkList) {
            result[index++] = chunk.getChunkStart();
            result[index++] = chunk.getChunkEnd();
        }
        return result;
    }

    private BitSet regionToBins(int startPos, int endPos) {
        int k;
        int end;
        int maxPos = 0x1FFFFFFF;
        int start = startPos <= 0 ? 0 : startPos - 1 & 0x1FFFFFFF;
        int n = end = endPos <= 0 ? 0x1FFFFFFF : endPos - 1 & 0x1FFFFFFF;
        if (start > end) {
            return null;
        }
        BitSet bitSet = new BitSet(37450);
        bitSet.set(0);
        for (k = 1 + (start >> 26); k <= 1 + (end >> 26); ++k) {
            bitSet.set(k);
        }
        for (k = 9 + (start >> 23); k <= 9 + (end >> 23); ++k) {
            bitSet.set(k);
        }
        for (k = 73 + (start >> 20); k <= 73 + (end >> 20); ++k) {
            bitSet.set(k);
        }
        for (k = 585 + (start >> 17); k <= 585 + (end >> 17); ++k) {
            bitSet.set(k);
        }
        for (k = 4681 + (start >> 14); k <= 4681 + (end >> 14); ++k) {
            bitSet.set(k);
        }
        return bitSet;
    }

    private long getFileBlock(long bgzfOffset) {
        return bgzfOffset >> 16 & 0xFFFFFFFFFFFFL;
    }

    private void openIndex() {
        if (this.mFileBuffer != null) {
            return;
        }
        this.openFileStream();
        this.seek(0);
        byte[] buffer = new byte[4];
        this.readBytes(buffer);
        if (!Arrays.equals(buffer, BAMFileConstants.BAM_INDEX_MAGIC)) {
            this.closeFileStream();
            throw new RuntimeException("Invalid file header in BAM index " + this.mFile + ": " + new String(buffer));
        }
    }

    private void readBytes(byte[] buffer) {
        this.mFileBuffer.get(buffer);
    }

    private int readInteger() {
        return this.mFileBuffer.getInt();
    }

    private long readLong() {
        return this.mFileBuffer.getLong();
    }

    private void skipBytes(int count) {
        this.mFileBuffer.position(this.mFileBuffer.position() + count);
    }

    private void seek(int position) {
        this.mFileBuffer.position(position);
    }

    private void openFileStream() {
        if (this.mFileStream != null) {
            return;
        }
        try {
            this.mFileStream = new FileInputStream(this.mFile);
            this.mFileChannel = this.mFileStream.getChannel();
            this.mFileBuffer = this.mFileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, this.mFileChannel.size());
            this.mFileBuffer.order(ByteOrder.LITTLE_ENDIAN);
        }
        catch (IOException exc) {
            throw new RuntimeIOException(exc.getMessage(), exc);
        }
    }

    private void closeFileStream() {
        try {
            this.mFileBuffer = null;
            if (this.mFileChannel != null) {
                this.mFileChannel.close();
                this.mFileChannel = null;
            }
            if (this.mFileStream != null) {
                this.mFileStream.close();
                this.mFileStream = null;
            }
        }
        catch (IOException exc) {
            throw new RuntimeIOException(exc.getMessage(), exc);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Chunk
    implements Comparable<Chunk> {
        private long mChunkStart;
        private long mChunkEnd;

        Chunk(long start, long end) {
            this.mChunkStart = start;
            this.mChunkEnd = end;
        }

        long getChunkStart() {
            return this.mChunkStart;
        }

        void setChunkStart(long value) {
            this.mChunkStart = value;
        }

        long getChunkEnd() {
            return this.mChunkEnd;
        }

        void setChunkEnd(long value) {
            this.mChunkEnd = value;
        }

        @Override
        public int compareTo(Chunk chunk) {
            int result = Long.signum(this.mChunkStart - chunk.mChunkStart);
            if (result == 0) {
                result = Long.signum(this.mChunkEnd - chunk.mChunkEnd);
            }
            return result;
        }
    }
}

