/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.preprocess;

import java.io.File;
import java.io.FilenameFilter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.broad.igv.data.Dataset;
import org.broad.igv.feature.Genome;
import org.broad.igv.feature.GenomeManager;
import org.broad.igv.preprocess.BinaryReader;
import org.broad.igv.preprocess.ChromosomeFileGroup;
import org.broad.igv.track.TrackType;

public class SolexaBinaryDataset
implements Dataset {
    private String name;
    private TrackType type = TrackType.CHIP;
    private Genome genome;
    private int wSpan = 25;
    private boolean normalized = false;
    Map<String, int[]> locations = new HashMap<String, int[]>();
    String sourceDirectory;
    FilenameFilter filter;
    BinaryReader reader;
    Map<String, ChromosomeFileGroup> fileGroups = new HashMap<String, ChromosomeFileGroup>();
    Set<String> dataHeadings = new LinkedHashSet<String>();
    Set<String> chromosomes = new HashSet<String>();
    Map<String, File> dataFileMap = new HashMap<String, File>();
    Map<String, Integer> chrDataSize = new HashMap<String, Integer>();

    public SolexaBinaryDataset(String name, TrackType type, String genomeId, String sourceDirectory, FilenameFilter filter) {
        this.name = name;
        this.type = type;
        this.genome = GenomeManager.getInstance().getGenome(genomeId);
        if (this.genome == null) {
            throw new RuntimeException("Unknown genome: " + genomeId);
        }
        this.sourceDirectory = sourceDirectory;
        this.filter = filter;
        this.reader = new BinaryReader();
        this.reader.setLittleEndian(true);
        this.initialize();
    }

    public String getName() {
        return this.name;
    }

    public TrackType getType() {
        return this.type;
    }

    public String[] getChromosomes() {
        String[] chrs = new String[this.chromosomes.size()];
        int i = 0;
        Iterator<String> i$ = this.chromosomes.iterator();
        while (i$.hasNext()) {
            String chr;
            chrs[i] = chr = i$.next();
            ++i;
        }
        return chrs;
    }

    public String[] getFeatureNames(String chr) {
        return null;
    }

    public String[] getDataHeadings() {
        String[] headings = new String[this.dataHeadings.size()];
        int i = 0;
        Iterator<String> i$ = this.dataHeadings.iterator();
        while (i$.hasNext()) {
            String h;
            headings[i] = h = i$.next();
            ++i;
        }
        return headings;
    }

    private void initialize() {
        List<File> files = this.reader.getDataFiles(this.sourceDirectory, this.filter);
        for (File file : files) {
            String[] tokens = file.getName().split("\\.");
            String chr = tokens[0];
            this.chromosomes.add(chr);
            String arrayName = tokens[1];
            int i = 2;
            while (!tokens[i].equals("bin") && !tokens[i].equals("cn")) {
                arrayName = arrayName + "." + tokens[i];
                ++i;
            }
            String key = arrayName + chr;
            this.dataFileMap.put(key, file);
            int nFilePts = (int)(file.length() / 4L);
            Integer nDataPoints = this.chrDataSize.get(chr);
            if (nDataPoints == null) {
                this.chrDataSize.put(chr, nFilePts);
            } else {
                this.chrDataSize.put(chr, Math.max(nFilePts, nDataPoints));
            }
            this.dataHeadings.add(arrayName);
        }
        for (Map.Entry entry : this.chrDataSize.entrySet()) {
            System.out.println("Chr: " + (String)entry.getKey() + "  Size= " + entry.getValue());
        }
    }

    public String getGenome() {
        return this.genome.getName();
    }

    public int[] getStartLocations(String chr) {
        int[] start = this.locations.get(chr);
        if (start == null) {
            int nPts = this.chrDataSize.get(chr);
            start = new int[nPts];
            for (int i = 0; i < nPts; ++i) {
                start[i] = 25 * i;
            }
            this.locations.put(chr, start);
        }
        return start;
    }

    public int[] getEndLocations(String chr) {
        return null;
    }

    public float[] getData(String heading, String chr) {
        int i;
        String key = heading + chr;
        File dataFile = this.dataFileMap.get(key);
        if (dataFile == null) {
            System.out.println("No data file for sample: " + heading + "  chromosome: " + chr);
            return null;
        }
        int nPts = this.chrDataSize.get(chr);
        int nFilePts = (int)(dataFile.length() / 4L);
        float[] fileData = this.reader.readFloats(dataFile);
        float[] data = new float[nPts];
        for (i = 0; i < nFilePts; ++i) {
            float fd = fileData[i];
            data[i] = fd < 0.0f ? Float.NaN : fd;
        }
        while (i < data.length) {
            data[i] = Float.NaN;
            ++i;
        }
        return data;
    }

    public int getWindowSpan() {
        return this.wSpan;
    }

    public void setWindowSpan(int wSpan) {
        this.wSpan = wSpan;
    }

    public boolean isLogNormalized() {
        return this.normalized;
    }

    public void setNormalized(boolean normalized) {
        this.normalized = normalized;
    }

    public boolean isLogValues() {
        return false;
    }

    public void setName(String name) {
        this.name = name;
    }

    public float getDataMin() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public float getDataMax() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getColorString() {
        return null;
    }
}

