/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.preprocess;

import cern.colt.list.DoubleArrayList;
import cern.jet.stat.quantile.DoubleQuantileFinder;
import cern.jet.stat.quantile.QuantileFinderFactory;
import java.util.LinkedHashMap;
import org.broad.igv.preprocess.DataStatistics;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessingUtils {
    public static float computeMean(float[] data) {
        if (data == null || data.length == 0) {
            return Float.NaN;
        }
        float sum = 0.0f;
        for (int i = 0; i < data.length; ++i) {
            sum += data[i];
        }
        return sum / (float)data.length;
    }

    public static DataStatistics computeStats(float[] data) {
        boolean noData = true;
        if (data != null && data.length > 0) {
            for (int i = 0; i < data.length; ++i) {
                if (Float.isNaN(data[i])) continue;
                noData = false;
                break;
            }
        }
        if (noData) {
            return DataStatistics.nullDataStat;
        }
        DataStatistics stats = new DataStatistics();
        DoubleArrayList al = new DoubleArrayList(2);
        al.add(0.1);
        al.add(0.5);
        al.add(0.9);
        al.add(0.98);
        DoubleQuantileFinder qf = QuantileFinderFactory.newDoubleQuantileFinder(true, data.length, 0.001, 0.001, al.size(), null);
        double minStat = Double.MAX_VALUE;
        double maxStat = -1.7976931348623157E308;
        double meanStat = 0.0;
        for (int i = 0; i < data.length; ++i) {
            if (!ProcessingUtils.isValidData(data[i])) continue;
            qf.add(data[i]);
            minStat = Math.min(minStat, (double)data[i]);
            maxStat = Math.max(maxStat, (double)data[i]);
            meanStat += (double)data[i];
        }
        if (qf.size() > 0L) {
            meanStat /= (double)qf.size();
            double err2 = 0.0;
            for (int i = 0; i < data.length; ++i) {
                if (!ProcessingUtils.isValidData(data[i])) continue;
                err2 += ((double)data[i] - meanStat) * ((double)data[i] - meanStat);
            }
            double stdDev = Math.sqrt(err2 / (double)qf.size());
            DoubleArrayList quantiles2 = qf.quantileElements(al);
            stats.setMin(minStat);
            stats.setMax(maxStat);
            stats.setMean(meanStat);
            stats.setPercentile10(quantiles2.get(0));
            stats.setMedian(quantiles2.get(1));
            stats.setPercentile90(quantiles2.get(2));
            stats.setPercentile98(quantiles2.get(3));
            stats.setStdDev(stdDev);
        }
        return stats;
    }

    public static double computeMedian(float[] data) {
        if (data.length > 0) {
            DoubleArrayList al = new DoubleArrayList();
            al.add(0.5);
            DoubleQuantileFinder qf = QuantileFinderFactory.newDoubleQuantileFinder(true, data.length, 0.001, 0.001, al.size(), null);
            for (int i = 0; i < data.length; ++i) {
                if (!ProcessingUtils.isValidData(data[i])) continue;
                qf.add(data[i]);
            }
            if (qf.size() > 0L) {
                DoubleArrayList quantiles2 = qf.quantileElements(al);
                return quantiles2.get(0);
            }
        }
        return 0.0;
    }

    private static boolean isValidData(float data) {
        return !Float.isNaN(data);
    }

    public static LinkedHashMap<String, String> parseArgs(String[] args) {
        return ProcessingUtils.parseArgs(args, 0);
    }

    public static LinkedHashMap<String, String> parseArgs(String[] args, int startIndex) {
        LinkedHashMap<String, String> argMap = new LinkedHashMap<String, String>();
        for (int i = startIndex; i < args.length; ++i) {
            String key = args[i].trim();
            if (args[i].trim().startsWith("-")) {
                String value = "";
                if (i < args.length - 1) {
                    if (args[++i].trim().startsWith("-")) {
                        value = "";
                        --i;
                    } else {
                        value = args[i].trim();
                    }
                    System.out.println(key + " = " + value);
                    argMap.put(key, value);
                    continue;
                }
                argMap.put(key, "");
                continue;
            }
            System.out.println(key);
            argMap.put(key, key);
        }
        return argMap;
    }
}

