/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.preprocess;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import org.broad.igv.feature.ParsingUtils;
import org.broad.igv.preprocess.Alignment;
import org.broad.igv.preprocess.AlignmentFileIterator;

public class MAQFileIterator
implements AlignmentFileIterator {
    static FileType type = FileType.ALIGNED;
    BufferedReader reader;
    String nextLine = null;
    Alignment nextAlignment;
    boolean closed;
    String[] tokens = new String[10];
    static String[] locusBuf = new String[2];

    public MAQFileIterator(File file) throws IOException {
        type = file.getName().endsWith("realign") || file.getName().endsWith("realign.txt") ? FileType.REALIGNED : FileType.ALIGNED;
        this.reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
        this.advance();
    }

    private void advance() throws IOException {
        this.nextAlignment = null;
        while ((this.nextLine = this.reader.readLine()) != null) {
            this.nextLine = this.nextLine.trim();
            if (this.nextLine.startsWith("#")) continue;
            char separator = type == FileType.ALIGNED ? (char)'\t' : ' ';
            int nTokens = ParsingUtils.split(this.nextLine, this.tokens, separator);
            if ((type != FileType.ALIGNED || nTokens < 3) && (type != FileType.REALIGNED || nTokens < 4)) continue;
            this.nextAlignment = type == FileType.ALIGNED ? this.getAlignment(this.tokens, nTokens) : this.getAlignmentSolexa(this.tokens, nTokens);
            break;
        }
    }

    public boolean hasNext() {
        return !this.closed && this.nextAlignment != null;
    }

    public Alignment next() throws IOException {
        Alignment retValue = this.nextAlignment;
        this.advance();
        return retValue;
    }

    public void close() throws IOException {
        this.reader.close();
        this.closed = true;
    }

    private Alignment getAlignment(String[] tokens, int nTokens) {
        String chr = tokens[0];
        int start = new Integer(tokens[1]);
        int end = new Integer(tokens[2]);
        boolean strand = false;
        if (nTokens > 3) {
            strand = tokens[3].trim().equals("-");
        }
        return new Alignment(chr, start, end, strand);
    }

    private Alignment getAlignmentSolexa(String[] tokens, int nTokens) {
        String sequence = tokens[0];
        String locusString = tokens[3];
        String strandString = tokens[4];
        ParsingUtils.split(locusString, locusBuf, ':');
        String chr = "chr" + locusBuf[0];
        int start = new Integer(locusBuf[1]);
        int end = start + sequence.length();
        boolean strand = strandString.equals("R");
        return new Alignment(chr, start, end, strand);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum FileType {
        ALIGNED,
        REALIGNED;

    }
}

