/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.preprocess;

import java.io.File;
import java.io.FilenameFilter;
import java.util.LinkedHashMap;
import org.broad.igv.data.IGVDataset;
import org.broad.igv.data.ResourceLocator;
import org.broad.igv.data.WiggleDataset;
import org.broad.igv.data.WiggleParser;
import org.broad.igv.preprocess.NonOverlappingProcessor;
import org.broad.igv.preprocess.ProcessingUtils;
import org.broad.igv.preprocess.SolexaBinaryDataset;
import org.broad.igv.track.TrackType;

public class IGVPreprocessor {
    static String usageString = "preprocess.sh inputFileOrDirectory  outputFileOrDirectory genome [-w windowSize] [-name trackName] [-type type]";

    public static void main(String[] args) {
        String shortFileName;
        if (args.length < 3) {
            System.out.println("Usage: " + usageString);
            System.exit(-1);
        }
        String inputDirectoryPath = args[0];
        String outputFN = args[1];
        String genomeId = args[2];
        LinkedHashMap<String, String> argMap = ProcessingUtils.parseArgs(args, 3);
        File inputFileOrDir = new File(inputDirectoryPath);
        File outputFile = new File(outputFN);
        int span = 25;
        String spanString = (String)argMap.get("-w");
        try {
            span = Integer.parseInt(spanString);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        String name = (String)argMap.get("-name");
        if (name == null) {
            name = outputFile.getName();
        }
        int maxZoom = 6;
        String maxZoomLevel = (String)argMap.get("-z");
        if (maxZoomLevel != null && maxZoomLevel.length() > 0) {
            try {
                maxZoom = Integer.parseInt(maxZoomLevel);
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println(numberFormatException.getMessage());
            }
        }
        if (!inputFileOrDir.exists()) {
            System.out.println("Cannot read input directory: " + inputFileOrDir.getAbsolutePath() + " Exiting.");
            System.exit(-1);
        }
        if (outputFile.isDirectory()) {
            System.out.println("Output file is a directory (" + outputFN + ".  Filename is required.  Exiting");
            System.exit(-1);
        }
        if ((shortFileName = inputFileOrDir.getName().toLowerCase()).endsWith(".txt") || shortFileName.endsWith(".tab") || shortFileName.endsWith(".xls")) {
            shortFileName = shortFileName.substring(0, shortFileName.lastIndexOf("."));
        }
        if (!inputFileOrDir.isDirectory() && (shortFileName.endsWith(".cn") || shortFileName.endsWith(".xcn") || shortFileName.endsWith(".snp"))) {
            IGVPreprocessor.processCN(inputFileOrDir, outputFile, genomeId, name, TrackType.COPY_NUMBER);
        } else if (inputFileOrDir.isDirectory()) {
            IGVPreprocessor.processCNBin(inputFileOrDir, outputFile, genomeId, name, TrackType.OTHER, span, null);
        } else {
            IGVPreprocessor.processWig(inputFileOrDir, outputFile, genomeId, name);
        }
    }

    private static void processCN(File inputFile, File outputFile, String genomeId, String name, TrackType type) {
        IGVDataset ds = new IGVDataset(genomeId, inputFile);
        ds.setName(name);
        ds.setTrackType(type);
        new NonOverlappingProcessor(ds, null).process(outputFile.getAbsolutePath());
    }

    private static void processCNBin(File inputDir, File outputFile, String genomeId, String name, TrackType type, int wSpan, final String filterString) {
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".bin") && !name.contains("_random") && (filterString == null || name.contains(filterString));
            }
        };
        SolexaBinaryDataset ds = new SolexaBinaryDataset(name, type, genomeId, inputDir.getAbsolutePath(), filter);
        ds.setWindowSpan(wSpan);
        ds.setNormalized(false);
        for (String nm : ds.getDataHeadings()) {
            System.out.println(nm);
        }
        new NonOverlappingProcessor(ds).process(outputFile.getAbsolutePath());
    }

    private static void processWig(File inputFile, File outputFile, String genomeId, String name) {
        WiggleDataset ds = new WiggleParser(new ResourceLocator(inputFile.getAbsolutePath()), genomeId).parse();
        ds.setName(name);
        for (String nm : ds.getDataHeadings()) {
            System.out.println(nm);
        }
        new NonOverlappingProcessor(ds).process(outputFile.getAbsolutePath());
    }
}

