/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.preprocess;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ChromosomeFileGroup {
    LocationType locationType = LocationType.LONG;
    private File locationFile;
    private File markerIdFile;
    private Map<String, File> dataFiles = new HashMap<String, File>();

    public ChromosomeFileGroup(LocationType type) {
        this.locationType = type;
    }

    public File getLocationFile() {
        return this.locationFile;
    }

    public void setLocationFile(File locationFile) {
        this.locationFile = locationFile;
    }

    public File getMarkerIdFile() {
        return this.markerIdFile;
    }

    public void setMarkerIdFile(File markerIdFile) {
        this.markerIdFile = markerIdFile;
    }

    public void addDataFile(String array, File dataFile) {
        this.dataFiles.put(array, dataFile);
    }

    public File getDataFile(String array) {
        return this.dataFiles.get(array);
    }

    public long getDataLength() {
        if (this.dataFiles.isEmpty()) {
            return 0L;
        }
        File anyDataFile = this.dataFiles.values().iterator().next();
        return anyDataFile.length() / 4L;
    }

    public Collection<String> getArrayNames() {
        return this.dataFiles.keySet();
    }

    public boolean validate() {
        if (this.locationFile == null) {
            System.err.println("Missing location file");
            return false;
        }
        if (this.dataFiles == null || this.dataFiles.isEmpty()) {
            System.err.println("No data files for " + this.locationFile.getName());
            return false;
        }
        if (!this.locationFile.exists()) {
            System.err.println("Location file: " + this.locationFile.getAbsolutePath() + " does not exist.");
            return false;
        }
        long fSize = this.locationFile.length();
        int nLocPoints = this.locationType == LocationType.LONG ? (int)(fSize / 8L) : (int)(fSize / 4L);
        for (File dataFile : this.dataFiles.values()) {
            if (!dataFile.exists()) {
                System.err.println("Data file: " + dataFile.getAbsolutePath() + " does not exist.");
                return false;
            }
            int nDataPts = (int)(dataFile.length() / 4L);
            if (nDataPts == nLocPoints) continue;
            System.err.println("Unexpected file size for file: " + dataFile.getName() + "  expected " + nLocPoints * 4 + " size = " + dataFile.length());
            return false;
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum LocationType {
        LONG,
        INT;

    }
}

