/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.preprocess;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.broad.igv.preprocess.ByteConverter;
import org.broad.igv.preprocess.EndianConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinaryReader {
    private boolean littleEndian = false;

    public BinaryReader() {
    }

    public BinaryReader(boolean littleEndian) {
        this.setLittleEndian(littleEndian);
    }

    public float[] readFloats(File file) {
        return this.convertBytesToFloats(this.readBytes(file));
    }

    public int[] readInts(File file) {
        try {
            int nInts = (int)(file.length() / 4L);
            int[] ints = new int[nInts];
            DataInputStream dis = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
            for (int i = 0; i < nInts; ++i) {
                if (dis.available() < 4) continue;
                ints[i] = dis.readInt();
            }
            dis.close();
            return ints;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
    }

    public long[] readLongs(File file) {
        try {
            int nLongs = (int)(file.length() / 8L);
            long[] longs = new long[nLongs];
            DataInputStream dis = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
            for (int i = 0; i < nLongs; ++i) {
                if (dis.available() < 8) continue;
                longs[i] = dis.readLong();
            }
            dis.close();
            return longs;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
    }

    protected byte[] readBytes(File file) {
        try {
            int fileSize = (int)file.length();
            BufferedInputStream inStream = new BufferedInputStream(new FileInputStream(file), fileSize);
            byte[] bytes = this.readBytes(inStream, fileSize);
            inStream.close();
            return bytes;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
    }

    public List<File> getDataFiles(String dataFileDirectory) {
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith("bin");
            }
        };
        return this.getDataFiles(dataFileDirectory, filter);
    }

    public List<File> getDataFiles(String dataFileDirectory, FilenameFilter filter) {
        File[] files;
        File dfd = new File(dataFileDirectory);
        if (!dfd.exists()) {
            System.err.println("Input directory: " + dfd.getAbsolutePath() + " does not exist.  Exiting!");
            System.exit(-1);
        }
        return (files = new File(dataFileDirectory).listFiles(filter)) == null ? new ArrayList() : Arrays.asList(files);
    }

    protected byte[] readBytes(InputStream inStream, int nBytes) throws IOException {
        byte[] bytes = new byte[nBytes];
        for (int bytesRead = 0; bytesRead < nBytes; bytesRead += inStream.read(bytes, bytesRead, inStream.available())) {
        }
        return bytes;
    }

    private float[] convertBytesToFloats(byte[] bytes) {
        if (this.littleEndian) {
            float[] floats = new float[bytes.length / 4];
            EndianConverter.convertLittleEndianToFloat(bytes, floats, bytes.length, 0, floats.length);
            return floats;
        }
        return ByteConverter.convertBytesToFloats(bytes);
    }

    public void setLittleEndian(boolean littleEndian) {
        this.littleEndian = littleEndian;
    }
}

