/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.preprocess;

import cern.colt.list.DoubleArrayList;
import cern.jet.stat.quantile.DoubleQuantileFinder;
import cern.jet.stat.quantile.QuantileFinderFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ncsa.hdf.hdf5lib.HDF5Constants;
import org.apache.log4j.Logger;
import org.broad.igv.data.Dataset;
import org.broad.igv.data.GenomeSummaryData;
import org.broad.igv.feature.Chromosome;
import org.broad.igv.feature.Genome;
import org.broad.igv.feature.GenomeManager;
import org.broad.igv.h5.HDF5LocalWriter;
import org.broad.igv.h5.HDFWriter;
import org.broad.igv.preprocess.Bin;
import org.broad.igv.preprocess.BinnedData;
import org.broad.igv.preprocess.DataStatistics;
import org.broad.igv.preprocess.ProcessingUtils;
import org.broad.igv.preprocess.StatusMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseProcessor {
    public static final String CHR_ALL = "All";
    private static Logger log = Logger.getLogger(BaseProcessor.class);
    private static int version = 3;
    private boolean verbose = false;
    private Dataset dataset;
    private Genome genome;
    private int tileSize = 700;
    private int zoomMax = 10;
    private int zoomMin = 2;
    private Set<String> chromosomeGroupKeys = new HashSet<String>();
    private Set<String> zoomGroupKeys = new HashSet<String>();
    private Set<String> datasetCache = new HashSet<String>();
    GenomeSummaryData genomeSummaryData;
    StatusMonitor statusMonitor;
    HDFWriter writer;
    boolean inferZeroes = false;

    public BaseProcessor(Dataset dataset, StatusMonitor statusMonitor) {
        this(dataset);
        this.statusMonitor = statusMonitor;
    }

    public BaseProcessor(Dataset dataset) {
        this.dataset = dataset;
        this.genome = GenomeManager.getInstance().getGenome(dataset.getGenome());
        this.genomeSummaryData = new GenomeSummaryData(this.genome);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean process(String outputFile) {
        this.writer = new HDF5LocalWriter();
        int file = this.writer.createFile(outputFile);
        try {
            int root = this.writer.openGroup(file, "/");
            this.writer.writeAttribute(root, "name", this.dataset.getName());
            this.writer.writeAttribute(root, "has.data", 1);
            this.writer.writeAttribute(root, "normalized", this.dataset.isLogNormalized() ? 1 : 0);
            this.writer.writeAttribute(root, "log.values", this.dataset.isLogNormalized() ? 1 : 0);
            this.writer.writeAttribute(root, "version", version);
            this.writer.writeAttribute(root, "type", (Object)this.dataset.getType());
            System.out.println("window.span = " + this.dataset.getWindowSpan());
            if (this.dataset.getWindowSpan() > 0) {
                this.writer.writeAttribute(root, "window.span", this.dataset.getWindowSpan());
            }
            if (this.dataset.getColorString() != null) {
                this.writer.writeAttribute(root, "track.color", this.dataset.getColorString());
            }
            double estTimeFraction = 0.1;
            int featureGroup = this.writer.createGroup(root, "features");
            Map<String, List<BinnedData>> binInfoMap = this.processFeatures(featureGroup, estTimeFraction);
            this.writer.closeGroup(featureGroup);
            int dataGroup = this.writer.createGroup(root, "data");
            this.writer.createAndWriteStringDataset(dataGroup, "track.id", this.dataset.getDataHeadings());
            estTimeFraction = 0.7;
            this.processData(dataGroup, binInfoMap, estTimeFraction);
            this.writer.closeGroup(dataGroup);
            this.writer.closeGroup(root);
            boolean bl = true;
            return bl;
        }
        catch (InterruptedException ex) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                this.writer.closeFile(file);
            }
            catch (Exception e) {
                if (!Thread.interrupted()) {
                    // empty if block
                }
            }
        }
    }

    private void checkForInterrupt() throws InterruptedException {
        if (Thread.interrupted()) {
            System.out.println("Interrupted");
            throw new InterruptedException();
        }
    }

    private Map<String, List<BinnedData>> processFeatures(int featureGroup, double estTimeFraction) throws InterruptedException {
        double progIncrement = estTimeFraction * 100.0 / (double)this.dataset.getChromosomes().length;
        HashMap<String, List<BinnedData>> binInfoMap = new HashMap<String, List<BinnedData>>();
        for (String chr : this.dataset.getChromosomes()) {
            this.checkForInterrupt();
            List<BinnedData> binnedData = this.processFeaturesForChromosome(chr, featureGroup);
            if (binnedData != null) {
                binInfoMap.put(chr, binnedData);
            }
            if (this.statusMonitor == null) continue;
            this.statusMonitor.incrementStatus(progIncrement);
        }
        binInfoMap.put(CHR_ALL, this.processFeaturesForChromosome(CHR_ALL, featureGroup));
        return binInfoMap;
    }

    private List<BinnedData> processFeaturesForChromosome(String chr, int featureGroup) throws InterruptedException {
        String[] featureNames;
        int maxLength = 0;
        if (chr.equals(CHR_ALL)) {
            int chrLength;
            maxLength = chrLength = (int)(this.genome.getLength() / 1000L);
        } else {
            Chromosome c = this.genome.getChromosome(chr);
            if (c == null) {
                System.out.println("Missing chromosome: " + chr);
                return null;
            }
            int chrLength = c.getLength();
            int[] locs = this.dataset.getEndLocations(chr);
            if (locs == null) {
                locs = this.dataset.getStartLocations(chr);
            }
            if ((maxLength = Math.max(chrLength, locs[locs.length - 1])) > chrLength) {
                // empty if block
            }
        }
        int chrGroup = this.writer.createGroup(featureGroup, chr);
        this.writer.writeAttribute(chrGroup, "length", maxLength);
        List<BinnedData> binnedDataList = this.computeAllBins(chr, maxLength);
        int numZoomLevels = binnedDataList.size() == 0 ? 0 : binnedDataList.get(binnedDataList.size() - 1).getZoomLevel() + 1;
        this.writer.writeAttribute(chrGroup, "zoom.levels", numZoomLevels);
        for (BinnedData binnedData : binnedDataList) {
            this.checkForInterrupt();
            String zoomName = "z" + binnedData.getZoomLevel();
            int zoomGroup = this.writer.createGroup(chrGroup, zoomName);
            this.writer.writeAttribute(zoomGroup, "bin.size", binnedData.getBinSize());
            double tileWidth = (double)this.tileSize * binnedData.getBinSize();
            this.writer.writeAttribute(zoomGroup, "tile.width", tileWidth);
            this.writer.writeAttribute(zoomGroup, "mean.count", binnedData.getMeanCount());
            this.writer.writeAttribute(zoomGroup, "median.count", binnedData.getMedianCount());
            this.writer.writeAttribute(zoomGroup, "max.count", binnedData.getMaxCount());
            this.writer.writeAttribute(zoomGroup, "percentile90.count", binnedData.getPercentile90Count());
            int[] locations = binnedData.getLocations();
            this.writer.createAndWriteVectorDataset(zoomGroup, "start", locations);
            int[] tileBoundaries = binnedData.getTileBoundaries();
            this.writer.createAndWriteVectorDataset(zoomGroup, "tile.boundary", tileBoundaries);
            float[] ptsPerBin = binnedData.getCounts();
            this.writer.createAndWriteVectorDataset(zoomGroup, "count", ptsPerBin);
            this.writer.closeGroup(zoomGroup);
        }
        int[] startLocations = this.getStartLocationsForChromosome(chr);
        int rawGroup = this.writer.createGroup(chrGroup, "raw");
        this.writer.createAndWriteVectorDataset(rawGroup, "start", startLocations);
        int[] endLocations = this.getEndLocationsForChromosome(chr);
        if (endLocations != null) {
            this.writer.createAndWriteVectorDataset(rawGroup, "end", endLocations);
        }
        if ((featureNames = this.dataset.getFeatureNames(chr)) != null) {
            this.writer.createAndWriteStringDataset(rawGroup, "feature", featureNames);
        }
        assert (maxLength < Integer.MAX_VALUE);
        this.recordRawIndex(rawGroup, maxLength, startLocations);
        this.writer.closeGroup(rawGroup);
        if (!chr.equals(CHR_ALL) && startLocations.length > 0) {
            this.genomeSummaryData.addLocations(chr, startLocations);
        }
        this.writer.closeGroup(chrGroup);
        return binnedDataList;
    }

    protected int getZoomMax() {
        return this.zoomMax;
    }

    private List<BinnedData> computeAllBins(String chr, long maxLength) {
        double binCountCutoff = 3.0;
        ArrayList<BinnedData> binInfoList = new ArrayList<BinnedData>();
        int adjustedZoomMax = chr.equals(CHR_ALL) ? 1 : this.getZoomMax();
        int[] startLocations = this.getStartLocationsForChromosome(chr);
        int[] endLocations = this.getEndLocationsForChromosome(chr);
        for (int z = 0; z < adjustedZoomMax; ++z) {
            int nTiles = (int)Math.pow(2.0, z);
            int nBins = nTiles * this.tileSize;
            double binSize = (double)maxLength / (double)nBins;
            if (binSize < 0.0) {
                System.out.println("Negative bin size");
            }
            List<Bin> bins = this.allocateBins(chr, nBins, binSize, startLocations, endLocations);
            BinnedData binInfo = this.computeBinnedData(z, maxLength, nTiles, bins, binSize);
            binInfoList.add(binInfo);
            if (binInfo.getMeanCount() < binCountCutoff && z > this.zoomMin) break;
        }
        return binInfoList;
    }

    protected abstract List<Bin> allocateBins(String var1, int var2, double var3, int[] var5, int[] var6);

    private void recordRawIndex(int groupId, int chrLength, int[] locations) {
        int n;
        double chunkSize = 10000.0;
        int nChunks = (int)((double)chrLength / chunkSize) + 1;
        int[] indices = new int[nChunks];
        int i = 0;
        for (n = 0; n < nChunks && i < locations.length; ++n) {
            int boundary = (int)((double)n * chunkSize);
            try {
                while (locations[i] < boundary && i < locations.length - 1) {
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            indices[n] = i;
        }
        while (n < nChunks) {
            indices[n] = locations.length - 1;
            ++n;
        }
        this.writer.writeAttribute(groupId, "index.span", chunkSize);
        this.writer.createAndWriteVectorDataset(groupId, "index", indices);
    }

    private void recordStats(DataStatistics[] stats, int group) {
        int nPts = stats.length;
        float[] min = new float[nPts];
        float[] mean = new float[nPts];
        float[] max = new float[nPts];
        float[] median = new float[nPts];
        float[] percentile10 = new float[nPts];
        float[] percentile90 = new float[nPts];
        float[] percentile98 = new float[nPts];
        float[] stddev = new float[nPts];
        for (int i = 0; i < nPts; ++i) {
            DataStatistics stat = stats[i];
            min[i] = stat == null ? Float.NaN : (float)stat.getMin();
            mean[i] = stat == null ? Float.NaN : (float)stats[i].getMean();
            max[i] = stat == null ? Float.NaN : (float)stats[i].getMax();
            median[i] = stat == null ? Float.NaN : (float)stats[i].getMedian();
            percentile10[i] = stat == null ? Float.NaN : (float)stats[i].getPercentile10();
            percentile90[i] = stat == null ? Float.NaN : (float)stats[i].getPercentile90();
            percentile98[i] = stat == null ? Float.NaN : (float)stats[i].getPercentile90();
            stddev[i] = stat == null ? Float.NaN : (float)stats[i].getStdDev();
        }
        this.writer.createAndWriteVectorDataset(group, "min", min);
        this.writer.createAndWriteVectorDataset(group, "mean", mean);
        this.writer.createAndWriteVectorDataset(group, "max", max);
        this.writer.createAndWriteVectorDataset(group, "median", median);
        this.writer.createAndWriteVectorDataset(group, "percentile10", percentile10);
        this.writer.createAndWriteVectorDataset(group, "percentile90", percentile90);
        this.writer.createAndWriteVectorDataset(group, "percentile98", percentile98);
        this.writer.createAndWriteVectorDataset(group, "stddev", stddev);
    }

    public int openChromosomeGroup(String chr, int dataGroup) {
        if (this.chromosomeGroupKeys.contains(chr)) {
            return this.writer.openGroup(dataGroup, chr);
        }
        int chrGroup = this.writer.createGroup(dataGroup, chr);
        this.chromosomeGroupKeys.add(chr);
        return chrGroup;
    }

    public int openZoomGroup(String chr, String zoomName, int chrGroup) {
        String key = chr + zoomName;
        if (this.zoomGroupKeys.contains(key)) {
            return this.writer.openGroup(chrGroup, zoomName);
        }
        int zoomGroup = this.writer.createGroup(chrGroup, zoomName);
        this.zoomGroupKeys.add(key);
        return zoomGroup;
    }

    public int openDataset(String chr, String zoomName, String dsName, int nCols, int zoomGroup) {
        String key = chr + zoomName + dsName;
        if (this.datasetCache.contains(key)) {
            int datasetId = this.writer.openDataset(zoomGroup, dsName);
            return datasetId;
        }
        int nRows = this.dataset.getDataHeadings().length;
        int datasetId = this.writer.createDataset(zoomGroup, dsName, HDF5Constants.H5T_NATIVE_FLOAT, new long[]{nRows, nCols});
        this.datasetCache.add(key);
        return datasetId;
    }

    public int openVectorDataset(String chr, String zoomName, String dsName, int zoomGroup) {
        String key = chr + zoomName + dsName;
        if (this.datasetCache.contains(key)) {
            int datasetId = this.writer.openDataset(zoomGroup, dsName);
            return datasetId;
        }
        int nRows = this.dataset.getDataHeadings().length;
        int datasetId = this.writer.createDataset(zoomGroup, dsName, HDF5Constants.H5T_NATIVE_FLOAT, new long[]{nRows});
        this.datasetCache.add(key);
        return datasetId;
    }

    private List<String> getAllChromosomes() {
        ArrayList<String> allChromosomes = new ArrayList<String>(Arrays.asList(this.dataset.getChromosomes()));
        allChromosomes.add(CHR_ALL);
        return allChromosomes;
    }

    private void processData(int dataGroup, Map<String, List<BinnedData>> binInfoMap, double estTimeFraction) throws InterruptedException {
        List<String> allChromosomes = this.getAllChromosomes();
        int nSteps = allChromosomes.size() * this.dataset.getDataHeadings().length;
        double procProgIncrement = estTimeFraction * 0.8 * 100.0 / (double)nSteps;
        double rawDataProgIncrement = estTimeFraction * 0.2 * 100.0 / (double)nSteps;
        for (String chr : allChromosomes) {
            this.checkForInterrupt();
            if (!chr.equals(CHR_ALL) && this.genome.getChromosome(chr) == null) continue;
            int chrGroup = this.openChromosomeGroup(chr, dataGroup);
            int sampleNumber = 0;
            boolean hasNulls = false;
            int nCols = 0;
            float[][] allData = new float[this.dataset.getDataHeadings().length][];
            DataStatistics[] stats = new DataStatistics[this.dataset.getDataHeadings().length];
            for (String sample : this.dataset.getDataHeadings()) {
                float[] data = this.getDataForChromosome(sample, chr);
                allData[sampleNumber] = data;
                if (data == null || data.length == 0) {
                    allData[sampleNumber] = null;
                    stats[sampleNumber] = null;
                    log.info("No data for array: " + sample + " chr: " + chr);
                } else {
                    this.checkForInterrupt();
                    nCols = data.length;
                    this.processDataForChromosome(sampleNumber, sample, chrGroup, binInfoMap.get(chr), chr);
                    if (this.statusMonitor != null) {
                        this.statusMonitor.incrementStatus(procProgIncrement);
                    }
                    if (this.statusMonitor != null) {
                        this.statusMonitor.incrementStatus(rawDataProgIncrement);
                    }
                    this.genomeSummaryData.addData(sample, chr, data);
                    stats[sampleNumber] = ProcessingUtils.computeStats(data);
                }
                ++sampleNumber;
            }
            if (hasNulls && nCols > 0) {
                float[] nanArray = new float[nCols];
                Arrays.fill(nanArray, Float.NaN);
                for (int i = 0; i < allData.length; ++i) {
                    if (allData[i] != null) continue;
                    allData[i] = nanArray;
                }
            }
            int rawGroup = this.openZoomGroup(chr, "raw", chrGroup);
            this.writer.createAndWriteDataset(rawGroup, "value", allData);
            this.recordStats(stats, rawGroup);
            this.writer.closeGroup(rawGroup);
            this.writer.closeGroup(chrGroup);
        }
    }

    float[] getDataForChromosome(String sample, String chr) {
        if (chr.equals(CHR_ALL)) {
            return this.genomeSummaryData.getData(sample);
        }
        return this.dataset.getData(sample, chr);
    }

    int[] getStartLocationsForChromosome(String chr) {
        if (chr.equals(CHR_ALL)) {
            return this.genomeSummaryData.getLocations();
        }
        return this.dataset.getStartLocations(chr);
    }

    int[] getEndLocationsForChromosome(String chr) {
        if (chr.equals(CHR_ALL)) {
            return null;
        }
        return this.dataset.getEndLocations(chr);
    }

    private void processDataForChromosome(int sampleNumber, String sample, int chrGroup, List<BinnedData> binnedDataList, String chr) throws InterruptedException {
        for (BinnedData binnedData : binnedDataList) {
            this.checkForInterrupt();
            List<? extends Bin> bins = binnedData.getBins();
            if (bins.size() <= 0) continue;
            float[] median = new float[bins.size()];
            float[] percent10 = new float[bins.size()];
            float[] percent90 = new float[bins.size()];
            float[] min = new float[bins.size()];
            float[] max = new float[bins.size()];
            float[] mean = new float[bins.size()];
            float[] stdDev = new float[bins.size()];
            float[] data = this.getDataForChromosome(sample, chr);
            for (int b = 0; b < bins.size(); ++b) {
                Bin bin = bins.get(b);
                float[] binData = this.getDataForBin(data, bin);
                if (binData == null) {
                    mean[b] = Float.NaN;
                    stdDev[b] = Float.NaN;
                    mean[b] = Float.NaN;
                    max[b] = Float.NaN;
                    percent10[b] = Float.NaN;
                    percent10[b] = Float.NaN;
                    median[b] = Float.NaN;
                    continue;
                }
                DataStatistics stats = ProcessingUtils.computeStats(binData);
                median[b] = (float)stats.getMedian();
                percent10[b] = (float)stats.getPercentile10();
                percent90[b] = (float)stats.getPercentile90();
                max[b] = (float)stats.getMax();
                min[b] = (float)stats.getMin();
                mean[b] = (float)stats.getMean();
                stdDev[b] = (float)stats.getStdDev();
                mean[b] = ProcessingUtils.computeMean(binData);
            }
            String zoomName = "z" + binnedData.getZoomLevel();
            int zoomGroup = this.openZoomGroup(chr, zoomName, chrGroup);
            this.recordStats("median", sampleNumber, median, zoomGroup, chr, zoomName);
            this.recordStats("percentile10", sampleNumber, percent10, zoomGroup, chr, zoomName);
            this.recordStats("percentile90", sampleNumber, percent90, zoomGroup, chr, zoomName);
            this.recordStats("min", sampleNumber, min, zoomGroup, chr, zoomName);
            this.recordStats("max", sampleNumber, max, zoomGroup, chr, zoomName);
            this.recordStats("mean", sampleNumber, mean, zoomGroup, chr, zoomName);
            this.recordStats("stdDev", sampleNumber, stdDev, zoomGroup, chr, zoomName);
            this.writer.closeGroup(zoomGroup);
        }
    }

    protected void recordStats(String type, int rowNumber, float[] data, int zoomGroup, String chr, String zoomName) {
        int dataArrayDataset = this.openDataset(chr, zoomName, type, data.length, zoomGroup);
        this.writer.writeDataRow(dataArrayDataset, rowNumber, data, data.length);
        this.writer.closeDataset(dataArrayDataset);
        float median = (float)ProcessingUtils.computeMedian(data);
        int medianDataset = this.openVectorDataset(chr, zoomName, "median." + type, zoomGroup);
        this.writer.writeDataValue(medianDataset, rowNumber, median);
        this.writer.closeDataset(medianDataset);
    }

    protected abstract float[] getDataForBin(float[] var1, Bin var2);

    private BinnedData computeBinnedData(int zoomLevel, double chrLength, int nTiles, List<Bin> bins, double binSize) {
        int[] tileBoundaries = new int[nTiles];
        int binNumber = 0;
        double tileLength = chrLength / (double)nTiles;
        for (int tileNumber = 0; tileNumber < nTiles - 1 && binNumber < bins.size(); ++tileNumber) {
            while ((double)bins.get(binNumber).getStart() < (double)(tileNumber + 1) * tileLength && ++binNumber < bins.size() - 2) {
            }
            tileBoundaries[tileNumber] = binNumber;
        }
        tileBoundaries[nTiles - 1] = bins.size() - 1;
        BinnedData binInfo = new BinnedData(zoomLevel, binSize, bins, tileBoundaries);
        float mean = 0.0f;
        float max = 0.0f;
        DoubleArrayList percentiles = new DoubleArrayList(3);
        percentiles.add(0.1);
        percentiles.add(0.5);
        percentiles.add(0.9);
        DoubleQuantileFinder qf = QuantileFinderFactory.newDoubleQuantileFinder(false, Long.MAX_VALUE, 0.001, 1.0E-4, percentiles.size(), null);
        for (Bin bin : bins) {
            int count = bin.getFeatureCount();
            mean += (float)count;
            max = Math.max(max, (float)count);
            qf.add(count);
        }
        binInfo.setMeanCount(mean / (float)bins.size());
        binInfo.setMaxCount(max);
        DoubleArrayList quantiles = qf.quantileElements(percentiles);
        binInfo.setPercentile10(quantiles.get(0));
        binInfo.setMedianCount(quantiles.get(1));
        binInfo.setPercentile90(quantiles.get(2));
        return binInfo;
    }

    public void setZoomMax(int zoomMax) {
        this.zoomMax = zoomMax;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }
}

