/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.preprocess;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.broad.igv.preprocess.AlignmentDataset;
import org.broad.igv.preprocess.NonOverlappingProcessor;
import org.broad.igv.preprocess.ProcessingUtils;
import org.broad.igv.preprocess.ReadCounter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlignmentProcessor {
    static String usageString = "run_<platform>  inputFile  outputFile genome [-m maskDirectory] [-w windowSize] [-ext extensionFactor] [-normalize]";

    public static void main(String[] args) {
        File[] files;
        File[] fileArray;
        if (args.length < 3) {
            System.out.println("Usage: " + usageString);
            System.exit(-1);
        }
        String inputDirectoryPath = args[0];
        String outputDirectoryPath = args[1];
        String genomeId = args[2];
        LinkedHashMap<String, String> argMap = ProcessingUtils.parseArgs(args, 3);
        File inputDirOrFile = new File(inputDirectoryPath);
        File outputFileOrDir = new File(outputDirectoryPath);
        if (inputDirOrFile.isDirectory() && !outputFileOrDir.isDirectory()) {
            System.out.println(outputFileOrDir + " is not a directory");
            System.exit(-1);
        }
        String maskDirectory = (String)argMap.get("-m");
        int span = 25;
        String spanString = (String)argMap.get("-w");
        try {
            span = Integer.parseInt(spanString);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        boolean normalize = argMap.containsKey("-normalize");
        System.out.println("Normalize = " + normalize);
        int extensionFactor = 0;
        String extFactorString = (String)argMap.get("-ext");
        if (extFactorString != null) {
            try {
                extensionFactor = Integer.parseInt((String)argMap.get("-ext"));
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("Extension factor (-ext) must be an integer.");
                System.exit(-1);
            }
        }
        int maxZoom = 6;
        String maxZoomLevel = (String)argMap.get("-z");
        if (maxZoomLevel != null && maxZoomLevel.length() > 0) {
            try {
                maxZoom = Integer.parseInt(maxZoomLevel);
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println(numberFormatException.getMessage());
            }
        }
        boolean replaceExistingFiles = true;
        Map<String, short[]> controlCounts = null;
        String controlFilename = (String)argMap.get("-c");
        File controlFile = null;
        if (controlFilename != null) {
            controlFile = controlFilename == null ? null : new File(inputDirOrFile, controlFilename);
            HashMap<String, Integer> ignore = new HashMap<String, Integer>();
            ReadCounter controlParser = new ReadCounter(controlFile);
            controlCounts = controlParser.doReadCounts((int)span, (int)extensionFactor, (String)genomeId, ignore).countsPreChr;
        }
        if (inputDirOrFile.isDirectory()) {
            fileArray = AlignmentProcessor.getInputFiles(inputDirOrFile);
        } else {
            File[] fileArray2 = new File[1];
            fileArray = fileArray2;
            fileArray2[0] = inputDirOrFile;
        }
        for (File file : files = fileArray) {
            File outputFile;
            if (controlFile != null && file.equals(controlFile)) continue;
            System.out.println("Processing: " + file.getName());
            String fn = file.getName() + ".h5";
            File file2 = outputFile = outputFileOrDir.isDirectory() ? new File(outputFileOrDir, fn) : outputFileOrDir;
            if (!replaceExistingFiles && outputFile.exists()) continue;
            AlignmentProcessor.processFile(file, outputFile, maskDirectory, genomeId, span, extensionFactor, maxZoom, controlCounts, normalize);
        }
    }

    public static File[] getInputFiles(File sourceDirectory) {
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File dir, String fn) {
                return fn.endsWith(".aligned") || fn.endsWith("aligned.txt") || fn.endsWith(".realign") || fn.endsWith(".realign.txt") || fn.endsWith(".bam") || fn.endsWith(".sam");
            }
        };
        return sourceDirectory.listFiles(filter);
    }

    public static void processFile(File inputFile, File outputFile, String maskDirectory, String genomeId, int span, int extensionFactor, int maxZoomLevel, Map<String, short[]> controlCounts, boolean normalize) {
        try {
            AlignmentDataset ds = new AlignmentDataset(inputFile, extensionFactor, maskDirectory, span, genomeId, controlCounts, normalize);
            NonOverlappingProcessor pr = new NonOverlappingProcessor(ds);
            pr.setZoomMax(maxZoomLevel);
            String ofileName = outputFile.getAbsolutePath();
            if (!ofileName.endsWith(".h5")) {
                ofileName = ofileName + ".h5";
            }
            pr.process(ofileName);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

