/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.preprocess;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import org.broad.igv.feature.Genome;
import org.broad.igv.feature.GenomeManager;
import org.broad.igv.feature.ParsingUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlignmentFileParser {
    static FileType type = FileType.ALIGNED;
    File file;
    static String[] locusBuf = new String[2];

    public AlignmentFileParser(File file) {
        this.file = file;
        type = file.getName().endsWith("realign") || file.getName().endsWith("realign.txt") ? FileType.REALIGNED : FileType.ALIGNED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, short[]> doReadCounts(int resolution, int extensionFactor, String genomeId, Map<String, Integer> lastPositionPerChr) {
        Genome genome = genomeId == null ? null : GenomeManager.getInstance().getGenome(genomeId);
        HashMap<String, short[]> readCountMap = new HashMap<String, short[]>();
        BufferedReader reader = null;
        try {
            String nextLine;
            reader = new BufferedReader(new InputStreamReader(new FileInputStream(this.file)));
            String[] tokens = new String[20];
            while ((nextLine = reader.readLine()) != null && nextLine.trim().length() > 0) {
                if ((nextLine = nextLine.trim()).startsWith("#")) continue;
                char separator = type == FileType.ALIGNED ? (char)'\t' : ' ';
                int nTokens = ParsingUtils.split(nextLine, tokens, separator);
                try {
                    LocusInfo locus;
                    if ((type != FileType.ALIGNED || nTokens < 3) && (type != FileType.REALIGNED || nTokens < 4)) continue;
                    LocusInfo locusInfo = locus = type == FileType.ALIGNED ? this.getLocusInfo(tokens, nTokens) : this.getLocusInfoSolexa(tokens, nTokens);
                    if (locus.strand.equalsIgnoreCase("+")) {
                        locus.end += extensionFactor;
                    } else if (locus.strand.equalsIgnoreCase("-")) {
                        locus.start = Math.max(0, locus.start - extensionFactor);
                    }
                    int lastPosition = lastPositionPerChr.containsKey(locus.chr) ? lastPositionPerChr.get(locus.chr) : 0;
                    lastPosition = Math.max(lastPosition, locus.end);
                    lastPositionPerChr.put(locus.chr, lastPosition);
                    short[] counts = (short[])readCountMap.get(locus.chr);
                    if (counts == null) {
                        int chrLength = 250000000;
                        if (genome != null && genome.getChromosome(locus.chr) != null) {
                            chrLength = genome.getChromosome(locus.chr).getLength();
                        }
                        int nPoints = (int)(1.1 * (double)chrLength / (double)resolution);
                        counts = new short[nPoints];
                        readCountMap.put(locus.chr, counts);
                    }
                    int maxIndex = counts.length - 1;
                    int startIndex = Math.min(maxIndex, locus.start / resolution);
                    int endIndex = Math.min(maxIndex, locus.end / resolution);
                    int i = startIndex;
                    while (i <= endIndex) {
                        int n = i++;
                        counts[n] = (short)(counts[n] + 1);
                    }
                }
                catch (Exception e) {
                    System.out.println("Error: " + e.getMessage() + "  Skipping line: " + nextLine);
                    e.printStackTrace();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                reader.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return readCountMap;
    }

    private LocusInfo getLocusInfo(String[] tokens, int nTokens) {
        String chr = tokens[0];
        int start = new Integer(tokens[1]);
        int end = new Integer(tokens[2]);
        String strand = ".";
        if (nTokens > 3) {
            strand = tokens[3];
        }
        return new LocusInfo(chr, start, end, strand);
    }

    private LocusInfo getLocusInfoSolexa(String[] tokens, int nTokens) {
        String sequence = tokens[0];
        String locusString = tokens[3];
        String strandString = tokens[4];
        ParsingUtils.split(locusString, locusBuf, ':');
        String chr = "chr" + locusBuf[0];
        int start = new Integer(locusBuf[1]);
        int end = start + sequence.length();
        String strand = strandString.equals("F") ? "+" : "-";
        return new LocusInfo(chr, start, end, strand);
    }

    static class LocusInfo {
        String chr;
        int start;
        int end;
        String strand;

        public LocusInfo(String chr, int start, int end, String strand) {
            this.chr = chr;
            this.start = start;
            this.end = end;
            this.strand = strand;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum FileType {
        ALIGNED,
        REALIGNED;

    }
}

