/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.preprocess;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.broad.igv.data.Dataset;
import org.broad.igv.data.IntArrayList;
import org.broad.igv.feature.Genome;
import org.broad.igv.feature.GenomeManager;
import org.broad.igv.preprocess.ReadCounter;
import org.broad.igv.track.TrackType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlignmentDataset
implements Dataset {
    int resolution;
    String genomeId;
    Genome genome;
    String name;
    Map<String, Integer> lastPositionPerChr;
    Map<String, int[]> starts;
    Map<String, float[]> values;
    boolean normalize = false;
    double normFactor = 1.0;

    public AlignmentDataset(File file, int extensionFactor, String maskDir, int resolution, String genomeId, Map<String, short[]> controlCounts, boolean normalize) throws IOException {
        this.genomeId = genomeId;
        this.genome = GenomeManager.getInstance().getGenome(genomeId);
        this.starts = new HashMap<String, int[]>();
        this.values = new HashMap<String, float[]>();
        this.resolution = resolution;
        this.name = file.getName();
        this.lastPositionPerChr = new HashMap<String, Integer>();
        this.normalize = normalize;
        System.out.println("Extension factor = " + extensionFactor);
        ReadCounter parser = new ReadCounter(file);
        ReadCounter.Counts countsRecord = parser.doReadCounts(resolution, extensionFactor, genomeId, this.lastPositionPerChr);
        Map<String, short[]> countsByChr = countsRecord.countsPreChr;
        if (normalize) {
            this.normFactor = 1000000.0 / (double)countsRecord.totalReadCount;
            System.out.println("Normalization factor = " + this.normFactor);
        }
        for (String chr : countsByChr.keySet()) {
            System.out.println(chr);
            short[] bpScores = countsByChr.get(chr);
            short[] controls = controlCounts == null ? null : controlCounts.get(chr);
            this.recordCounts(chr, bpScores, maskDir, controls);
        }
    }

    private void recordCounts(String chr, short[] counts, String maskDir, short[] controls) throws IOException {
        MaskData maskSet;
        MaskData maskData = maskSet = maskDir == null || maskDir.trim().length() == 0 ? null : this.parseMaskFile(maskDir, chr);
        if (maskSet != null) {
            System.out.println("Mask set size = " + maskSet.getSize());
        }
        int len = this.lastPositionPerChr.get(chr) / this.resolution + 1;
        int[] startPositions = new int[len];
        float[] vals = new float[len];
        int nextMaskedPosition = maskSet == null ? -1 : maskSet.getNext();
        for (int pos = 0; pos < this.lastPositionPerChr.get(chr); pos += this.resolution) {
            int idx = pos / this.resolution;
            if (idx >= counts.length) continue;
            int data = counts[idx];
            if (controls != null) {
                data -= controls[idx];
            }
            startPositions[idx] = pos;
            if (pos == nextMaskedPosition) {
                vals[idx] = Float.NaN;
                nextMaskedPosition = maskSet.getNext();
                continue;
            }
            vals[idx] = this.normalize ? (float)((double)data * this.normFactor) : (float)data;
        }
        this.starts.put(chr, startPositions);
        this.values.put(chr, vals);
    }

    private MaskData parseMaskFile(String maskDir, String chr) throws IOException {
        IntArrayList maskIndeces = new IntArrayList(4000000);
        File[] files = new File(maskDir).listFiles();
        if (files == null) {
            System.out.println("No mask directory or no files in mask directory: " + maskDir);
        }
        File file = files[0];
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].getName().startsWith(chr)) continue;
            file = files[i];
        }
        FileInputStream is = new FileInputStream(file);
        DataInputStream dis = new DataInputStream(is);
        int i = 0;
        try {
            while (true) {
                int temp;
                if ((temp = dis.readUnsignedByte()) == 0) {
                    maskIndeces.add(i * this.resolution);
                }
                ++i;
            }
        }
        catch (Exception ex) {
            return new MaskData(maskIndeces.toArray());
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getGenome() {
        return this.genomeId;
    }

    @Override
    public String[] getChromosomes() {
        String[] rtrn = new String[this.values.size()];
        int i = 0;
        Iterator<String> i$ = this.values.keySet().iterator();
        while (i$.hasNext()) {
            String chr;
            rtrn[i] = chr = i$.next();
            ++i;
        }
        return rtrn;
    }

    @Override
    public String[] getDataHeadings() {
        String[] rtrn = new String[]{this.name};
        return rtrn;
    }

    @Override
    public int[] getStartLocations(String chr) {
        return this.starts.get(chr);
    }

    @Override
    public int[] getEndLocations(String chr) {
        return null;
    }

    @Override
    public String[] getFeatureNames(String chr) {
        return null;
    }

    @Override
    public int getWindowSpan() {
        return this.resolution;
    }

    public boolean isNormalized() {
        return true;
    }

    public boolean isLogValues() {
        return false;
    }

    @Override
    public float[] getData(String heading, String chr) {
        return this.values.get(chr);
    }

    @Override
    public void setName(String name) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public TrackType getType() {
        return TrackType.CHIP;
    }

    @Override
    public boolean isLogNormalized() {
        return true;
    }

    @Override
    public String getColorString() {
        return null;
    }

    static class MaskData {
        private int[] maskedPositions;
        private int next = 0;

        MaskData(int[] maskIndeces) {
            this.maskedPositions = maskIndeces;
        }

        int getNext() {
            if (this.next >= this.maskedPositions.length) {
                return -1;
            }
            int rtn = this.maskedPositions[this.next];
            ++this.next;
            return rtn;
        }

        int getSize() {
            return this.maskedPositions.length;
        }
    }
}

