/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.h5;

import java.io.FileNotFoundException;
import java.lang.reflect.Array;
import ncsa.hdf.hdf5lib.H5;
import ncsa.hdf.hdf5lib.HDF5Constants;
import ncsa.hdf.hdf5lib.exceptions.HDF5Exception;
import ncsa.hdf.hdf5lib.exceptions.HDF5LibraryException;
import ncsa.hdf.hdf5lib.exceptions.HDF5SymbolTableException;
import org.apache.log4j.Logger;
import org.broad.igv.h5.DataAccessException;
import org.broad.igv.h5.HDFWriter;
import org.broad.igv.h5.ObjectNotFoundException;

public class HDF5LocalWriter
implements HDFWriter {
    private static Logger log = Logger.getLogger(HDF5LocalWriter.class);
    public static int RDWR = HDF5Constants.H5F_ACC_RDWR;

    public int createFile(String name) {
        try {
            return H5.H5Fcreate(name, HDF5Constants.H5F_ACC_TRUNC, HDF5Constants.H5P_DEFAULT, HDF5Constants.H5P_DEFAULT);
        }
        catch (HDF5LibraryException ex) {
            String msg = "Error creating HDF5 file";
            log.error(msg, ex);
            throw new DataAccessException(msg, ex);
        }
    }

    public int openFile(String path) throws FileNotFoundException {
        return this.openFile(path, RDWR);
    }

    public int openFile(String path, int mode) throws FileNotFoundException {
        try {
            return H5.H5Fopen(path, mode, HDF5Constants.H5P_DEFAULT);
        }
        catch (HDF5LibraryException ex) {
            String msg = "Error opening HDF5 file: " + path;
            log.error(msg, ex);
            throw new DataAccessException(msg, ex);
        }
    }

    public void closeFile(int fileId) {
        try {
            H5.H5Fclose(fileId);
        }
        catch (HDF5LibraryException ex) {
            String msg = "Error closing HDF5 file";
            log.error(msg, ex);
            throw new DataAccessException(msg, ex);
        }
    }

    public int openDataset(int fileId, String dsName) {
        try {
            return H5.H5Dopen(fileId, dsName);
        }
        catch (HDF5SymbolTableException ex) {
            throw new ObjectNotFoundException("Error opening dataset: " + dsName);
        }
        catch (HDF5LibraryException ex) {
            log.error("Error opening dataset", ex);
            throw new RuntimeException(ex);
        }
    }

    public void closeDataset(int datasetId) {
        try {
            H5.H5Dclose(datasetId);
        }
        catch (HDF5LibraryException ex) {
            log.error("Error closing dataset", ex);
            throw new RuntimeException("Error closing dataset");
        }
    }

    public int createGroup(int locId, String name) {
        try {
            return H5.H5Gcreate(locId, name, 0);
        }
        catch (HDF5LibraryException ex) {
            String msg = "Error creating group: " + name;
            log.error(msg, ex);
            throw new DataAccessException(msg, ex);
        }
    }

    public int openGroup(int locId, String name) {
        try {
            return H5.H5Gopen(locId, name);
        }
        catch (HDF5SymbolTableException ex) {
            String msg = "Error opening group: " + name;
            if (log.isDebugEnabled()) {
                log.debug(msg, ex);
            }
            throw new ObjectNotFoundException(msg);
        }
        catch (HDF5LibraryException ex) {
            String msg = "Error opening group: " + name;
            log.error(msg, ex);
            throw new DataAccessException(msg, ex);
        }
    }

    public void closeGroup(int groupId) {
        try {
            H5.H5Gclose(groupId);
        }
        catch (HDF5LibraryException ex) {
            String msg = "Error closing HDF5 group";
            log.error(msg, ex);
            throw new DataAccessException(msg, ex);
        }
    }

    public int createDataset(int locId, String name, int typeId, long[] dims) {
        try {
            int dataspace = H5.H5Screate_simple(dims.length, dims, null);
            return H5.H5Dcreate(locId, name, typeId, dataspace, HDF5Constants.H5P_DEFAULT);
        }
        catch (HDF5Exception ex) {
            String msg = "Error creating dataset: " + name;
            log.error(msg, ex);
            throw new DataAccessException(msg, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createAndWriteDataset(int nodeId, String dsName, float[][] data) {
        int typeInfo = HDF5Constants.H5T_NATIVE_FLOAT;
        int nRows = Array.getLength(data);
        if (nRows == 0) {
            log.info("Attempt to create zero length dataset: " + dsName);
        } else {
            long nCols = data[0].length;
            long[] dims = new long[]{nRows, nCols};
            int dataset = -1;
            try {
                dataset = this.createDataset(nodeId, dsName, typeInfo, dims);
                this.writeAllData(dataset, typeInfo, data);
            }
            finally {
                if (dataset > 0) {
                    this.closeDataset(dataset);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createAndWriteVectorDataset(int nodeId, String dsName, Object data) {
        if (data instanceof String[]) {
            this.createAndWriteStringDataset(nodeId, dsName, (String[])data);
        }
        int typeInfo = this.getTypeForArray(data);
        int length = Array.getLength(data);
        if (length == 0) {
            log.info("Attempt to create zero length dataset: " + dsName);
        } else {
            long[] dims = new long[]{length};
            int dataset = -1;
            try {
                dataset = this.createDataset(nodeId, dsName, typeInfo, dims);
                this.writeAllData(dataset, typeInfo, data);
            }
            finally {
                if (dataset > 0) {
                    this.closeDataset(dataset);
                }
            }
        }
    }

    private int getTypeForArray(Object array) {
        if (array instanceof Integer || array instanceof int[] || array instanceof int[][]) {
            return HDF5Constants.H5T_NATIVE_INT;
        }
        if (array instanceof Long || array instanceof long[] || array instanceof long[][]) {
            return HDF5Constants.H5T_NATIVE_LLONG;
        }
        if (array instanceof Float || array instanceof float[] || array instanceof float[][]) {
            return HDF5Constants.H5T_NATIVE_FLOAT;
        }
        if (array instanceof Number || array instanceof double[] || array instanceof double[][]) {
            return HDF5Constants.H5T_NATIVE_DOUBLE;
        }
        if (array instanceof char[]) {
            return this.createStringDatatype(1);
        }
        String msg = "Error: No HDF Type for: " + array.getClass().getName();
        log.error(msg);
        throw new DataAccessException("No HDF Type for: " + array.getClass().getName());
    }

    public void createAndWriteStringDataset(int locId, String dsName, String[] stringArray) {
        int maxSize = 0;
        for (String string : stringArray) {
            maxSize = Math.max(maxSize, string.length());
        }
        this.createAndWriteStringDataset(locId, dsName, stringArray, maxSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createAndWriteStringDataset(int locId, String dsName, String[] stringArray, int stringSize) {
        StringBuffer sb = new StringBuffer(stringArray.length * stringSize);
        for (int i = 0; i < stringArray.length; ++i) {
            char[] chars = new char[stringSize];
            char[] tmp = stringArray[i].toCharArray();
            System.arraycopy(tmp, 0, chars, 0, tmp.length);
            sb.append(new String(chars));
        }
        byte[] buf = sb.toString().getBytes();
        int dataType = this.createStringDatatype(stringSize);
        long[] dims = new long[]{stringArray.length};
        int nameDS = -1;
        try {
            nameDS = this.createDataset(locId, dsName, dataType, dims);
            this.writeAllData(nameDS, dataType, buf);
        }
        finally {
            if (nameDS > 0) {
                this.closeDataset(nameDS);
            }
        }
    }

    public int createStringDatatype(int strLength) {
        try {
            int tid = H5.H5Tcopy(HDF5Constants.H5T_C_S1);
            H5.H5Tset_size(tid, strLength);
            return tid;
        }
        catch (HDF5LibraryException ex) {
            String msg = "Error creating string datatype. Length = " + strLength;
            log.error(msg, ex);
            throw new DataAccessException(msg, ex);
        }
    }

    public void writeAllData(int datasetId, int type, Object data) {
        try {
            int status = H5.H5Dwrite(datasetId, type, HDF5Constants.H5S_ALL, HDF5Constants.H5S_ALL, HDF5Constants.H5S_ALL, data);
            if (status != 0) {
                throw new DataAccessException("Error writing data: " + status);
            }
        }
        catch (HDF5Exception ex) {
            String msg = "Error writing data";
            log.error(msg, ex);
            throw new DataAccessException(msg, ex);
        }
    }

    public void writeDataRow(int datasetId, int rowId, float[] data, int length) {
        try {
            int dataspace = this.getDataspace(datasetId);
            long[] offset = new long[2];
            long[] count = new long[2];
            offset[0] = rowId;
            offset[1] = 0L;
            count[0] = 1L;
            count[1] = length;
            int status1 = H5.H5Sselect_hyperslab(dataspace, HDF5Constants.H5S_SELECT_SET, offset, null, count, null);
            if (status1 != 0) {
                log.error("Error selecting hyberslab  Error code:" + status1);
                throw new DataAccessException("Error selecting hyberslab.  Error code: " + status1);
            }
            int memspace = H5.H5Screate_simple(1, new long[]{length}, null);
            int type = this.getTypeForArray(data);
            int status = H5.H5Dwrite(datasetId, type, memspace, dataspace, HDF5Constants.H5S_ALL, data);
            H5.H5Sclose(dataspace);
            if (status != 0) {
                throw new DataAccessException("Error writing data: " + status);
            }
        }
        catch (HDF5Exception ex) {
            String msg = "Error writing data row.  rowId= " + rowId + " length= " + length;
            ex.printStackTrace();
            log.error(msg, ex);
            throw new DataAccessException(msg, ex);
        }
    }

    public void writeDataValue(int datasetId, int cellId, float value) {
        try {
            int dataspace = this.getDataspace(datasetId);
            long[] offset = new long[1];
            long[] count = new long[1];
            offset[0] = cellId;
            count[0] = 1L;
            int status1 = H5.H5Sselect_hyperslab(dataspace, HDF5Constants.H5S_SELECT_SET, offset, null, count, null);
            int memspace = H5.H5Screate_simple(1, new long[]{1L}, null);
            int type = HDF5Constants.H5T_NATIVE_FLOAT;
            int status = H5.H5Dwrite(datasetId, type, memspace, dataspace, HDF5Constants.H5S_ALL, new float[]{value});
            H5.H5Sclose(dataspace);
            if (status != 0) {
                throw new DataAccessException("Error writing data: " + status);
            }
        }
        catch (HDF5Exception ex) {
            String msg = "Error writing data value.  cellId= " + cellId + " value= " + value;
            log.error(msg, ex);
            throw new DataAccessException(msg, ex);
        }
    }

    public int deleteAttribute(int locId, String name) {
        try {
            int herr = H5.H5Adelete(locId, name);
            return herr;
        }
        catch (HDF5LibraryException ex) {
            String msg = "Error deleting attribute.  locId= " + locId + " name= " + name;
            throw new DataAccessException(msg, ex);
        }
    }

    public int writeAttribute(int locId, String name, Object value) {
        try {
            int dataType = 0;
            Object[] buf = null;
            if (value instanceof Integer) {
                dataType = HDF5Constants.H5T_NATIVE_INT;
                buf = new int[]{((Number)value).intValue()};
            } else if (value instanceof Long) {
                dataType = HDF5Constants.H5T_NATIVE_LLONG;
                buf = new long[]{((Number)value).longValue()};
            } else if (value instanceof Float) {
                dataType = HDF5Constants.H5T_NATIVE_FLOAT;
                buf = new float[]{((Number)value).floatValue()};
            } else if (value instanceof Number) {
                dataType = HDF5Constants.H5T_NATIVE_DOUBLE;
                buf = new double[]{((Number)value).doubleValue()};
            } else {
                dataType = H5.H5Tcopy(H5.J2C(HDF5Constants.H5T_C_S1));
                buf = value.toString().getBytes();
                H5.H5Tset_size(dataType, ((byte[])buf).length);
            }
            int spaceId = H5.H5Screate(HDF5Constants.H5S_SCALAR);
            int attrId = H5.H5Acreate(locId, name, dataType, spaceId, HDF5Constants.H5P_DEFAULT);
            int status = H5.H5Awrite(attrId, dataType, buf);
            status = H5.H5Sclose(spaceId);
            status = H5.H5Aclose(attrId);
            return status;
        }
        catch (HDF5Exception ex) {
            String msg = "Error writing to dataset ";
            log.error(msg, ex);
            throw new DataAccessException(msg, ex);
        }
    }

    private int getDataspace(int datasetId) {
        try {
            return H5.H5Dget_space(datasetId);
        }
        catch (HDF5LibraryException ex) {
            String msg = "Error getting dataspace";
            log.error(msg);
            throw new DataAccessException(msg, ex);
        }
    }
}

