/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.h5;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class BufferedFileOutputStream
extends BufferedOutputStream {
    private long bytesWritten = 0L;

    public BufferedFileOutputStream(OutputStream out) {
        this(out, 8192);
    }

    public BufferedFileOutputStream(OutputStream out, int size) {
        super(out);
        if (size <= 0) {
            throw new IllegalArgumentException("Buffer size <= 0");
        }
        this.buf = new byte[size];
    }

    public synchronized void write(int b) throws IOException {
        super.write(b);
        ++this.bytesWritten;
    }

    public synchronized void write(byte[] b, int off, int len) throws IOException {
        super.write(b, off, len);
        this.bytesWritten += (long)len;
    }

    public synchronized long position() {
        return this.bytesWritten;
    }
}

