/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.h5;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.broad.igv.h5.BinBase;
import org.broad.igv.h5.BufferedFileOutputStream;
import org.broad.igv.h5.H5Constants;
import org.broad.igv.h5.HDFWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinWriter
extends BinBase
implements HDFWriter {
    private static Logger log = Logger.getLogger(BinWriter.class);
    private static byte version = 1;
    int fileId;
    File file;
    BufferedFileOutputStream fos = null;

    public BinWriter(File file) {
        this.file = file;
    }

    @Override
    public int createFile(String filename) {
        String fullpath = new File(filename).getAbsolutePath();
        if (!this.file.getAbsolutePath().equals(fullpath)) {
            throw new IllegalArgumentException("Filename mismatch.  Expected " + this.file.getAbsolutePath() + " argument: " + filename);
        }
        try {
            this.fileId = this.file.getAbsolutePath().hashCode();
            this.addEntity(this.fileId, "/");
            this.fos = new BufferedFileOutputStream(new FileOutputStream(this.file));
            this.fos.write(version);
            return this.fileId;
        }
        catch (IOException ex) {
            log.error("Error creating file: " + filename, ex);
            throw new RuntimeException("Error creating file: " + filename, ex);
        }
    }

    @Override
    public void closeFile(int fileId) {
        if (this.fileId != fileId) {
            throw new IllegalArgumentException("FileId mismatch.  Expected " + this.fileId + " argument: " + fileId);
        }
        try {
            this.writeGroups();
            this.fos.close();
        }
        catch (IOException ex) {
            log.error("Error closing file");
        }
    }

    private void writeDataset(Map<BinBase.Dataset, Long> datasetPositions, BinBase.Dataset dataset) throws IOException {
        datasetPositions.put(dataset, this.fos.position());
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(buffer);
        dos.writeUTF(dataset.fullName);
        dos.writeUTF(dataset.type.toString());
        dos.writeInt(dataset.nRows);
        dos.writeInt(dataset.nColumns);
        dos.writeInt(dataset.attributes.size());
        for (Map.Entry kvPair : dataset.attributes.entrySet()) {
            dos.writeUTF((String)kvPair.getKey());
            dos.writeUTF((String)kvPair.getValue());
        }
        for (int i = 0; i < dataset.nRows; ++i) {
            dos.writeLong(dataset.rowPositions[i]);
        }
        byte[] bytes = buffer.toByteArray();
        this.writeInt(bytes.length);
        this.write(bytes);
    }

    void writeShort(short v) throws IOException {
        this.fos.write(v >>> 8 & 0xFF);
        this.fos.write(v >>> 0 & 0xFF);
    }

    void writeInt(int v) throws IOException {
        this.fos.write(v >>> 24 & 0xFF);
        this.fos.write(v >>> 16 & 0xFF);
        this.fos.write(v >>> 8 & 0xFF);
        this.fos.write(v >>> 0 & 0xFF);
    }

    void write(byte[] bytes) throws IOException {
        this.fos.write(bytes);
    }

    private void writeGroups() throws IOException {
        LinkedHashMap<BinBase.Dataset, Long> datasetPositions = new LinkedHashMap<BinBase.Dataset, Long>();
        for (BinBase.Dataset dataset : this.datasetCache.values()) {
            this.writeDataset(datasetPositions, dataset);
        }
        long indexStartPosition = this.fos.position();
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(buffer);
        dos.writeInt(datasetPositions.size());
        for (Map.Entry entry : datasetPositions.entrySet()) {
            dos.writeUTF(((BinBase.Dataset)entry.getKey()).fullName);
            dos.writeLong((Long)entry.getValue());
        }
        int n = 0;
        for (BinBase.Group group : this.groupCache.values()) {
            if (group.isEmpty()) continue;
            ++n;
        }
        dos.writeInt(n);
        for (BinBase.Group group : this.groupCache.values()) {
            if (group.isEmpty()) continue;
            dos.writeUTF(group.fullName);
            dos.writeInt(group.attributes.size());
            for (Map.Entry kvPair : group.attributes.entrySet()) {
                dos.writeUTF((String)kvPair.getKey());
                dos.writeUTF((String)kvPair.getValue());
            }
        }
        dos.writeLong(indexStartPosition);
        this.write(buffer.toByteArray());
    }

    @Override
    public void closeDataset(int datasetId) {
    }

    @Override
    public void closeGroup(int groupId) {
    }

    private BinBase.DataType convertType(int hdfType) {
        if (hdfType == H5Constants.NATIVE_FLOAT) {
            return BinBase.DataType.FLOAT;
        }
        if (hdfType == H5Constants.NATIVE_DOUBLE) {
            return BinBase.DataType.DOUBLE;
        }
        if (hdfType == H5Constants.NATIVE_INT) {
            return BinBase.DataType.INT;
        }
        if (hdfType == H5Constants.NATIVE_SHORT) {
            return BinBase.DataType.SHORT;
        }
        return BinBase.DataType.STRING;
    }

    @Override
    public void createAndWriteStringDataset(int locId, String dsName, String[] stringArray, int stringSize) {
        this.createAndWriteStringDataset(locId, dsName, stringArray);
    }

    @Override
    public int createDataset(int locId, String name, int typeId, long[] dims) {
        BinBase.DataType dataType = this.convertType(typeId);
        String fullName = this.getFullName(locId, name);
        int nRows = (int)(dims.length < 2 ? 1L : dims[0]);
        int nCols = (int)(dims.length >= 2 ? dims[1] : dims[0]);
        BinBase.Dataset dataset = new BinBase.Dataset(fullName, nRows, nCols, dataType);
        int id = fullName.hashCode();
        this.datasetCache.put(id, dataset);
        this.entityIdMap.put(fullName, id);
        return id;
    }

    @Override
    public int createGroup(int locId, String name) {
        if (!this.groupCache.containsKey(locId)) {
            throw new IllegalArgumentException("Illegal entity identifier (trying to create entity " + name + ")");
        }
        String fullName = this.getFullName(locId, name);
        int id = fullName.hashCode();
        this.addEntity(id, fullName);
        return id;
    }

    @Override
    public int openDataset(int fileId, String dsName) {
        return this.openEntity(fileId, dsName);
    }

    @Override
    public int openGroup(int locId, String name) {
        return this.openEntity(locId, name);
    }

    private int openEntity(int locId, String name) {
        String fullName = name.startsWith("/") ? name : this.getFullName(locId, name);
        return this.getEntityId(fullName);
    }

    @Override
    public int writeAttribute(int locId, String name, Object value) {
        this.getEntity((int)locId).attributes.put(name, value.toString());
        return 1;
    }

    @Override
    public void writeDataValue(int datasetId, int rowNumber, float value) {
    }

    @Override
    public void writeDataRow(int datasetId, int rowId, float[] data, int length) {
        try {
            BinBase.Dataset ds = (BinBase.Dataset)this.datasetCache.get(datasetId);
            if (ds == null) {
                // empty if block
            }
            ds.rowPositions[rowId] = this.fos.position();
            this.write(this.convertToBytes(data));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private byte[] convertToBytes(float[] data) {
        byte[] bytes = new byte[data.length * 4];
        for (int i = 0; i < data.length; ++i) {
            int v = Float.floatToIntBits(data[i]);
            int byteIdx = i * 4;
            bytes[byteIdx++] = (byte)(v >>> 24 & 0xFF);
            bytes[byteIdx++] = (byte)(v >>> 16 & 0xFF);
            bytes[byteIdx++] = (byte)(v >>> 8 & 0xFF);
            bytes[byteIdx++] = (byte)(v >>> 0 & 0xFF);
        }
        return bytes;
    }

    private byte[] convertToBytes(int[] data) {
        byte[] bytes = new byte[data.length * 4];
        for (int i = 0; i < data.length; ++i) {
            int v = data[i];
            int byteIdx = i * 4;
            bytes[byteIdx++] = (byte)(v >>> 24 & 0xFF);
            bytes[byteIdx++] = (byte)(v >>> 16 & 0xFF);
            bytes[byteIdx++] = (byte)(v >>> 8 & 0xFF);
            bytes[byteIdx++] = (byte)(v >>> 0 & 0xFF);
        }
        return bytes;
    }

    @Override
    public void createAndWriteVectorDataset(int locId, String dsName, Object data) {
        if (data instanceof int[]) {
            this.createAndWriteIntDataset(locId, dsName, (int[])data);
        } else if (data instanceof float[]) {
            this.createAndWriteFloatDataset(locId, dsName, (float[])data);
        } else {
            throw new RuntimeException("Unsupported type: " + data.getClass());
        }
    }

    @Override
    public void createAndWriteStringDataset(int locId, String dsName, String[] stringArray) {
        try {
            long[] dims = new long[]{stringArray.length};
            int dsId = this.createDataset(locId, dsName, H5Constants.STRING, dims);
            BinBase.Dataset dataset = (BinBase.Dataset)this.datasetCache.get(dsId);
            dataset.rowPositions[0] = this.fos.position();
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(buffer);
            for (String s : stringArray) {
                dos.writeUTF(s);
            }
            byte[] bytes = buffer.toByteArray();
            int sz = bytes.length;
            this.writeInt(sz);
            this.write(bytes);
        }
        catch (IOException ex) {
            log.error("Error creating string dataset: " + dsName, ex);
            throw new RuntimeException("Error creating string dataset: " + dsName, ex);
        }
    }

    private void createAndWriteIntDataset(int locId, String dsName, int[] data) {
        try {
            long[] dims = new long[]{data.length};
            int dsId = this.createDataset(locId, dsName, H5Constants.STRING, dims);
            BinBase.Dataset dataset = (BinBase.Dataset)this.datasetCache.get(dsId);
            dataset.rowPositions[0] = this.fos.position();
            this.write(this.convertToBytes(data));
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void createAndWriteFloatDataset(int locId, String dsName, float[] data) {
        try {
            long[] dims = new long[]{data.length};
            int dsId = this.createDataset(locId, dsName, H5Constants.STRING, dims);
            BinBase.Dataset dataset = (BinBase.Dataset)this.datasetCache.get(dsId);
            dataset.rowPositions[0] = this.fos.position();
            this.write(this.convertToBytes(data));
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void createAndWriteDataset(int locId, String dsName, float[][] data) {
        try {
            long[] dims = new long[]{data.length, data[0].length};
            int dsId = this.createDataset(locId, dsName, H5Constants.NATIVE_FLOAT, dims);
            BinBase.Dataset dataset = (BinBase.Dataset)this.datasetCache.get(dsId);
            for (int i = 0; i < data.length; ++i) {
                dataset.rowPositions[i] = this.fos.position();
                this.write(this.convertToBytes(data[i]));
            }
        }
        catch (IOException iOException) {
            log.error("Error creating dataset: " + dsName, iOException);
            throw new RuntimeException("Error creating dataset: " + dsName, iOException);
        }
    }
}

