/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import net.sf.samtools.util.AsciiLineReader;
import org.apache.log4j.Logger;
import org.broad.igv.data.ResourceLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParsingUtils {
    private static Logger log = Logger.getLogger(ParsingUtils.class);
    static Set<String> legacyGenomes = new HashSet<String>();
    private static Map<String, String> chrLookupTable;

    public static BufferedReader openBufferedReader(ResourceLocator locator) throws FileNotFoundException, IOException {
        if (locator.isLocal()) {
            return ParsingUtils.openBufferedReader(locator.getPath());
        }
        URL url = new URL(locator.getServerURL() + "?method=getContents&file=" + locator.getPath());
        URLConnection connection = url.openConnection();
        return new BufferedReader(new InputStreamReader(new GZIPInputStream(connection.getInputStream())));
    }

    public static BufferedReader openBufferedReader(String pathOrUrl) throws FileNotFoundException, IOException {
        BufferedReader reader = null;
        if (pathOrUrl.startsWith("http:") || pathOrUrl.startsWith("file:")) {
            URL url = new URL(pathOrUrl);
            URLConnection connection = url.openConnection();
            reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        } else {
            File file = new File(pathOrUrl);
            FileInputStream fileInput = new FileInputStream(file);
            if (file.getName().endsWith("gz")) {
                GZIPInputStream in = new GZIPInputStream(fileInput);
                reader = new BufferedReader(new InputStreamReader(in));
            } else {
                reader = new BufferedReader(new InputStreamReader(fileInput));
            }
        }
        return reader;
    }

    public static AsciiLineReader openAsciiReader(ResourceLocator locator) throws FileNotFoundException, IOException {
        InputStream stream = ParsingUtils.openInputStream(locator);
        return new AsciiLineReader(stream);
    }

    public static InputStream openInputStream(ResourceLocator locator) throws FileNotFoundException, IOException {
        Object reader = null;
        if (locator.isLocal()) {
            File file = new File(locator.getPath());
            FileInputStream fileInput = new FileInputStream(file);
            if (file.getName().endsWith("gz")) {
                return new GZIPInputStream(fileInput);
            }
            return fileInput;
        }
        URL url = new URL(locator.getServerURL() + "?method=getContents&file=" + locator.getPath());
        URLConnection connection = url.openConnection();
        return new GZIPInputStream(connection.getInputStream());
    }

    public static int split(String aString, String[] tokens, char delim) {
        String trailingString;
        int maxTokens = tokens.length;
        int nTokens = 0;
        int start = 0;
        int end = aString.indexOf(delim);
        if (end < 0) {
            tokens[nTokens++] = aString;
            return nTokens;
        }
        while (end > 0 && nTokens < maxTokens) {
            tokens[nTokens++] = aString.substring(start, end);
            start = end + 1;
            end = aString.indexOf(delim, start);
        }
        if (nTokens < maxTokens && (trailingString = aString.substring(start)).length() > 0) {
            tokens[nTokens++] = trailingString;
        }
        return nTokens;
    }

    public static List<String> loadRegions(File file) {
        try {
            String nextLine;
            FileInputStream fileInput = new FileInputStream(file);
            BufferedReader reader = new BufferedReader(new InputStreamReader(fileInput));
            ArrayList<String> features = new ArrayList<String>();
            while ((nextLine = reader.readLine()) != null && nextLine.trim().length() > 0) {
                try {
                    if (!nextLine.startsWith("chr")) continue;
                    String[] tokens = nextLine.split("\t");
                    String region = tokens[0] + ":" + tokens[1] + "-" + tokens[2];
                    features.add(region);
                }
                catch (NumberFormatException e) {
                    log.error("Error parsing numer in line: " + nextLine);
                }
            }
            reader.close();
            return features;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String lookupChr(String genomeId, String str) {
        String chr = chrLookupTable.get(str);
        if (chr == null) {
            chr = str;
            if (genomeId.startsWith("hg")) {
                chr = chr.replace("23", "X");
                chr = (chr = chr.replace("24", "Y")).startsWith("chr") ? chr : "chr" + chr;
            } else if (genomeId.startsWith("mm")) {
                chr = chr.replace("20", "X");
                chr = (chr = chr.replace("21", "Y")).startsWith("chr") ? chr : "chr" + chr;
            } else if (legacyGenomes.contains(genomeId)) {
                chr = chr.startsWith("chr") ? chr : "chr" + chr;
            }
            chrLookupTable.put(str, chr.trim());
        }
        return chr;
    }

    public static String convertChrString(String genomeId, String chr) {
        return ParsingUtils.lookupChr(genomeId, chr);
    }

    static {
        legacyGenomes.add("S._cerevisiae");
        legacyGenomes.add("Yeast_S._pombe");
        legacyGenomes.add("Chicken_galGal3");
        chrLookupTable = new Hashtable<String, String>();
    }
}

