/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import org.broad.igv.feature.CytoBandFileParser;
import org.broad.igv.feature.Genome;

public class GenomeManager {
    private static GenomeManager theInstance = null;
    private Map<String, Genome> genomeMap = new HashMap<String, Genome>();

    private GenomeManager() {
    }

    public static synchronized GenomeManager getInstance() {
        if (theInstance == null) {
            theInstance = new GenomeManager();
        }
        return theInstance;
    }

    public Genome getGenome(String id) {
        Genome genome = this.genomeMap.get(id);
        if (genome == null) {
            genome = new Genome(id);
            String cytobandFile = "/resources/" + id + "_cytoBand.txt";
            InputStream is = GenomeManager.class.getResourceAsStream(cytobandFile);
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            genome.setChromosomeMap(CytoBandFileParser.loadData(reader));
        }
        return genome;
    }
}

