/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.LinkedHashMap;
import org.broad.igv.feature.Chromosome;
import org.broad.igv.feature.Cytoband;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CytoBandFileParser {
    public static LinkedHashMap<String, Chromosome> loadData(BufferedReader reader) {
        LinkedHashMap<String, Chromosome> dataMap = new LinkedHashMap<String, Chromosome>();
        try {
            String nextLine;
            while ((nextLine = reader.readLine()) != null && nextLine.trim().length() > 0) {
                String[] data = nextLine.split("\t");
                String chr = data[0].trim();
                Chromosome chromosome = dataMap.get(chr);
                if (chromosome == null) {
                    chromosome = new Chromosome(chr);
                    dataMap.put(chr, chromosome);
                }
                Cytoband cytoData = new Cytoband(chr);
                CytoBandFileParser.parseData(nextLine.split("\t"), cytoData);
                chromosome.addCytoband(cytoData);
            }
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return dataMap;
    }

    private static void parseData(String[] tokens, Cytoband cytoData) {
        try {
            cytoData.setStart(Integer.parseInt(tokens[1].trim()));
            cytoData.setEnd(Integer.parseInt(tokens[2].trim()));
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Error parsing gene row " + tokens[1]);
        }
    }

    private static String parseChromosome(String[] data) {
        String chr = data[0].substring(3);
        int underscore = chr.indexOf(95);
        if (underscore > 0) {
            chr = chr.substring(0, underscore);
        }
        return chr;
    }
}

