/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature;

import java.util.ArrayList;
import java.util.List;
import org.broad.igv.feature.Cytoband;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Chromosome {
    private String name;
    private int centrimere = 0;
    private List<Cytoband> cytobands;
    private int length = 0;

    public Chromosome(String name) {
        this.name = name;
        this.cytobands = new ArrayList<Cytoband>();
    }

    public int getCentrimere() {
        return this.centrimere;
    }

    public void setCentrimere(int centrimere) {
        this.centrimere = centrimere;
    }

    public List<Cytoband> getCytobands() {
        return this.cytobands;
    }

    public void setCytobands(List<Cytoband> cytobands) {
        this.cytobands = cytobands;
    }

    public void addCytoband(Cytoband band) {
        this.cytobands.add(band);
        if (band.getType() == 'c' && this.centrimere == 0) {
            this.centrimere = band.getEnd();
        }
        this.length = Math.max(this.length, band.getEnd());
    }

    public int getLength() {
        return this.length;
    }

    public String getName() {
        return this.name;
    }
}

