/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.data.wgs;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.broad.igv.data.Dataset;
import org.broad.igv.feature.Genome;
import org.broad.igv.feature.GenomeManager;
import org.broad.igv.preprocess.NonOverlappingProcessor;
import org.broad.igv.track.TrackType;

public class SeqDataset
implements Dataset {
    String genomeId;
    Genome genome;
    String trackName;
    File directory;
    File lociFile;
    String color;
    String[] chromosomes;
    Map<String, List<int[]>> lociMap = new HashMap<String, List<int[]>>();

    public SeqDataset(String path, String fn) {
        this.directory = new File(path);
        this.lociFile = new File(fn);
        this.readProperties();
        this.readLoci();
        this.genome = GenomeManager.getInstance().getGenome(this.genomeId);
    }

    public void setLociFile(File lociFile) {
        this.lociFile = lociFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readLoci() {
        if (this.lociFile != null && this.lociFile.exists()) {
            BufferedReader br = null;
            try {
                br = new BufferedReader(new FileReader(this.lociFile));
                String nextLine = null;
                while ((nextLine = br.readLine()) != null) {
                    try {
                        String locusString = nextLine.trim();
                        String[] t1 = locusString.split(":");
                        String chr = t1[0];
                        String[] t2 = t1[1].split("-");
                        if (t2.length != 2) continue;
                        int[] pos = new int[]{Integer.parseInt(t2[0]), Integer.parseInt(t2[1])};
                        List<int[]> posList = this.lociMap.get(chr);
                        if (posList == null) {
                            posList = new ArrayList<int[]>();
                            this.lociMap.put(chr, posList);
                        }
                        posList.add(pos);
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println("Ignoring locus line: " + nextLine);
                    }
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            finally {
                try {
                    br.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
            this.chromosomes = this.lociMap.keySet().toArray(new String[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readProperties() {
        File propFile = new File(this.directory, "property.txt");
        if (propFile.exists()) {
            InputStream is = null;
            try {
                Properties props = new Properties();
                is = new FileInputStream(propFile);
                props.load(is);
                is.close();
                this.genomeId = props.getProperty("genome");
                this.trackName = props.getProperty("name");
                this.color = props.getProperty("color");
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        } else {
            this.genomeId = "hg18";
            this.trackName = this.directory.getName();
            this.color = "0,0,255";
        }
    }

    private void scanForChromosomes() {
        File[] files = this.directory.listFiles(new FileFilter(){

            public boolean accept(File arg0) {
                return arg0.getName().startsWith("chr") && arg0.getName().endsWith(".bin");
            }
        });
        this.chromosomes = new String[files.length];
        for (int i = 0; i < files.length; ++i) {
            this.chromosomes[i] = files[i].getName().replace(".bin", "").trim();
        }
    }

    public String getName() {
        return this.trackName;
    }

    public TrackType getType() {
        return TrackType.OTHER;
    }

    public String getGenome() {
        return this.genomeId;
    }

    public String[] getChromosomes() {
        return this.chromosomes;
    }

    public String getTrackName() {
        return this.trackName;
    }

    public int getWindowSpan() {
        return 1;
    }

    public void setName(String name) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String[] getDataHeadings() {
        return new String[]{this.trackName};
    }

    public int[] getStartLocations(String chr) {
        List<int[]> positions = this.lociMap.get(chr);
        int sz = 0;
        for (int[] pos : positions) {
            sz += pos[1] - pos[0];
        }
        int idx = 0;
        int[] locs = new int[sz];
        for (int[] pos : positions) {
            int i = pos[0];
            while (i < pos[1]) {
                locs[idx] = i++;
                ++idx;
            }
        }
        return locs;
    }

    public int[] getEndLocations(String chr) {
        return null;
    }

    public String[] getFeatureNames(String chr) {
        return null;
    }

    public boolean isLogNormalized() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float[] getData(String heading, String chr) {
        FilterInputStream dis = null;
        File inputFile = new File(this.directory, chr + ".bin");
        if (!inputFile.exists()) {
            return null;
        }
        List<int[]> positions = this.lociMap.get(chr);
        int sz = 0;
        for (int[] pos : positions) {
            sz += pos[1] - pos[0];
        }
        float[] data = new float[sz];
        int lastPos = 0;
        try {
            dis = new DataInputStream(new BufferedInputStream(new FileInputStream(inputFile)));
            for (int[] pos : positions) {
                dis.skip((pos[0] - lastPos) * 16 / 8);
                for (int i = pos[0]; i < pos[1]; ++i) {
                    if (dis.available() < 2) continue;
                    data[i - pos[0]] = ((DataInputStream)dis).readShort();
                }
                lastPos = pos[1];
            }
            dis.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                dis.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return data;
    }

    public String getColorString() {
        return this.color;
    }

    public static void main(String[] args) {
        SeqDataset ds = new SeqDataset(args[0], args[1]);
        float[] data = ds.getData("ignored", "chr4");
        NonOverlappingProcessor proc = new NonOverlappingProcessor(ds);
        proc.setZoomMax(7);
        proc.process(args[2]);
        System.out.println(data.length);
    }
}

