/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.data;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.broad.igv.data.Dataset;
import org.broad.igv.data.FloatArrayList;
import org.broad.igv.data.IntArrayList;
import org.broad.igv.data.TrackProperties;
import org.broad.igv.track.TrackType;
import org.broad.igv.util.ArrayHeapSorter;

public class WiggleDataset
implements Dataset {
    String genome;
    private String name;
    private TrackProperties trackProperties;
    Map<String, IntArrayList> startLocationsMap = new HashMap<String, IntArrayList>();
    Map<String, IntArrayList> endLocationsMap = new HashMap<String, IntArrayList>();
    Map<String, FloatArrayList> dataMap = new HashMap<String, FloatArrayList>();

    public WiggleDataset(String genomeId, String name) {
        this.genome = genomeId;
        this.name = name;
        this.trackProperties = new TrackProperties();
    }

    public void sort() {
        for (String chr : this.startLocationsMap.keySet()) {
            final int[] starts = this.startLocationsMap.get(chr).toArray();
            int[] indeces = new int[starts.length];
            for (int i = 0; i < indeces.length; ++i) {
                indeces[i] = i;
            }
            new ArrayHeapSorter().sort(indeces, new Comparator<Integer>(){

                @Override
                public int compare(Integer arg0, Integer arg1) {
                    return starts[arg0] - starts[arg1];
                }
            });
            this.startLocationsMap.get(chr).reorder(indeces);
            this.endLocationsMap.get(chr).reorder(indeces);
            this.dataMap.get(chr).reorder(indeces);
        }
    }

    public void addDataChunk(String chr, IntArrayList starts, IntArrayList ends, FloatArrayList data) {
        FloatArrayList dataArray;
        IntArrayList startLocations = this.startLocationsMap.get(chr);
        if (startLocations == null) {
            this.startLocationsMap.put(chr, starts);
        } else {
            startLocations.addAll(starts.toArray());
        }
        if (ends != null) {
            IntArrayList endLocations = this.endLocationsMap.get(chr);
            if (startLocations == null) {
                this.endLocationsMap.put(chr, ends);
            } else {
                endLocations.addAll(ends.toArray());
            }
        }
        if ((dataArray = this.dataMap.get(chr)) == null) {
            this.dataMap.put(chr, data);
        } else {
            dataArray.addAll(data.toArray());
        }
    }

    public float getDataMin() {
        return 0.0f;
    }

    public float getDataMax() {
        return 10.0f;
    }

    public String getName() {
        return this.name;
    }

    public TrackType getType() {
        return TrackType.OTHER;
    }

    public String getGenome() {
        return this.genome;
    }

    public String[] getChromosomes() {
        return this.startLocationsMap.keySet().toArray(new String[0]);
    }

    public String[] getDataHeadings() {
        return new String[]{this.getName()};
    }

    public int[] getStartLocations(String chr) {
        IntArrayList startLocations = this.startLocationsMap.get(chr);
        return startLocations == null ? null : startLocations.toArray();
    }

    public int[] getEndLocations(String chr) {
        IntArrayList endLocations = this.endLocationsMap.get(chr);
        return endLocations == null ? null : endLocations.toArray();
    }

    public float[] getData(String heading, String chr) {
        FloatArrayList data = this.dataMap.get(chr);
        return data == null ? null : data.toArray();
    }

    public String[] getFeatureNames(String chr) {
        return null;
    }

    public int getWindowSpan() {
        return 1;
    }

    public boolean isLogNormalized() {
        return false;
    }

    public boolean isLogValues() {
        return false;
    }

    public void setName(String name) {
        this.name = name;
    }

    public TrackProperties getTrackProperties() {
        return this.trackProperties;
    }

    public String getColorString() {
        return "0,0,255";
    }
}

