/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.data;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;

public class ResourceLocator {
    String name;
    String serverURL;
    String path;
    String hyperLink;
    String description;

    public boolean exists() {
        if (this.isLocal()) {
            return new File(this.path).exists();
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResourceLocator other = (ResourceLocator)obj;
        if (!(this.serverURL == other.serverURL || this.serverURL != null && this.serverURL.equals(other.serverURL))) {
            return false;
        }
        return this.path == other.path || this.path != null && this.path.equals(other.path);
    }

    public int hashCode() {
        int hash = 7;
        hash = 29 * hash + (this.serverURL != null ? this.serverURL.hashCode() : 0);
        hash = 29 * hash + (this.path != null ? this.path.hashCode() : 0);
        return hash;
    }

    public ResourceLocator(URL url) throws UnsupportedEncodingException {
        StringBuffer buffer = new StringBuffer();
        buffer.append(url.getProtocol());
        buffer.append("://");
        buffer.append(url.getHost());
        int port = url.getPort();
        if (port != -1) {
            buffer.append(":");
            buffer.append(port);
        }
        this.serverURL = buffer.toString();
        this.path = URLDecoder.decode(url.getFile(), "UTF-8");
    }

    public ResourceLocator(String path) {
        this.serverURL = null;
        this.path = path;
    }

    public ResourceLocator(String serverURL, String path) {
        this.serverURL = serverURL;
        this.path = path;
    }

    public URL toURL() throws MalformedURLException {
        return new URL(this.serverURL + this.path);
    }

    public String getPath() {
        return this.path;
    }

    public String getServerURL() {
        return this.serverURL;
    }

    public boolean isLocal() {
        return this.serverURL == null;
    }

    public void setHyperLink(String hyperLink) {
        this.hyperLink = hyperLink;
    }

    public String getHyperLink() {
        return this.hyperLink;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDisplayName() {
        return this.name == null ? new File(this.getPath()).getName() : this.name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AttributeType {
        DESCRIPTION("description"),
        HYPERLINK("hyperlink"),
        NAME("name"),
        SERVER_URL("serverURL"),
        PATH("path");

        private String name;

        private AttributeType(String name) {
            this.name = name;
        }

        public String getText() {
            return this.name;
        }

        public String toString() {
            return this.getText();
        }

        public static AttributeType findEnum(String value) {
            if (value == null) {
                return null;
            }
            if (value.equals(SERVER_URL.getText())) {
                return SERVER_URL;
            }
            if (value.equals(PATH.getText())) {
                return PATH;
            }
            if (value.equals(DESCRIPTION.getText())) {
                return DESCRIPTION;
            }
            if (value.equals(HYPERLINK.getText())) {
                return HYPERLINK;
            }
            if (value.equals(NAME.getText())) {
                return NAME;
            }
            return null;
        }
    }
}

