/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.data;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.broad.igv.data.ChromosomeData;
import org.broad.igv.data.ChromosomeSummary;
import org.broad.igv.data.DatasetParserUtils;
import org.broad.igv.data.FloatArrayList;
import org.broad.igv.data.IGVDataset;
import org.broad.igv.data.IntArrayList;
import org.broad.igv.data.ResourceLocator;
import org.broad.igv.data.WindowFunction;
import org.broad.igv.feature.ParsingUtils;
import org.broad.igv.track.TrackType;
import org.broad.igv.util.AsciiLineReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IGVDatasetParser {
    private static Logger log = Logger.getLogger(IGVDatasetParser.class);
    private ResourceLocator dataResourceLocator;
    private int chrColumn;
    private int startColumn;
    private int endColumn;
    private int firstDataColumn;
    private boolean hasEndLocations;
    private boolean hasCalls;
    private String genomeId;
    static String[] tokens = new String[10000];

    public IGVDatasetParser(ResourceLocator copyNoFile, String genomeId) {
        this.dataResourceLocator = copyNoFile;
        this.genomeId = genomeId;
        this.initParameters();
    }

    private void initParameters() {
        String tmp;
        String string = tmp = this.dataResourceLocator.getPath().endsWith(".txt") ? this.dataResourceLocator.getPath().substring(0, this.dataResourceLocator.getPath().length() - 4) : this.dataResourceLocator.getPath();
        if (tmp.endsWith(".igv")) {
            this.chrColumn = 0;
            this.startColumn = 1;
            this.endColumn = 2;
            this.firstDataColumn = 4;
            this.hasEndLocations = true;
            this.hasCalls = false;
        } else {
            this.chrColumn = 1;
            this.startColumn = 2;
            this.endColumn = -1;
            this.firstDataColumn = 3;
            this.hasEndLocations = false;
            this.hasCalls = tmp.endsWith(".xcn") || tmp.endsWith(".snp");
        }
    }

    public List<ChromosomeSummary> scan(IGVDataset dataset) {
        float dataMin = 0.0f;
        float dataMax = 0.0f;
        long filePosition = 0L;
        try {
            ArrayList<ChromosomeSummary> chrSummaries = new ArrayList<ChromosomeSummary>();
            int skipColumns = this.hasCalls ? 2 : 1;
            InputStream is = ParsingUtils.openInputStream(this.dataResourceLocator);
            AsciiLineReader reader = new AsciiLineReader(is);
            if (this.isCopyNumberFileExt(this.dataResourceLocator.getPath())) {
                dataset.setTrackType(TrackType.COPY_NUMBER);
                dataset.getTrackProperties().setWindowingFunction(WindowFunction.median);
            } else {
                dataset.getTrackProperties().setWindowingFunction(WindowFunction.mean);
            }
            String nextLine = reader.readLine(true);
            filePosition += (long)nextLine.length();
            while (nextLine.startsWith("#") || nextLine.trim().length() == 0) {
                if (nextLine.length() > 0) {
                    this.parseComment(nextLine, dataset);
                }
                nextLine = reader.readLine(true);
                filePosition += (long)nextLine.length();
            }
            String[] data = nextLine.trim().split("\t");
            String[] headings = this.getHeadings(data, skipColumns);
            dataset.setDataHeadings(headings);
            boolean logNormalized = false;
            ChromosomeSummary chrSummary = null;
            WholeGenomeData wgData = new WholeGenomeData(headings);
            int nRows = 0;
            while ((nextLine = reader.readLine(true)) != null) {
                int nBytes = nextLine.length();
                int nTokens = ParsingUtils.split(nextLine.trim(), tokens, '\t');
                if (nTokens > 0) {
                    String thisChr = ParsingUtils.convertChrString(this.genomeId, tokens[this.chrColumn].trim());
                    if (chrSummary == null || !thisChr.equals(chrSummary.getName())) {
                        if (chrSummary != null) {
                            this.updateWholeGenome(chrSummary.getName(), dataset, headings, wgData);
                            chrSummary.setNDataPoints(nRows);
                        }
                        chrSummary = new ChromosomeSummary(thisChr, filePosition);
                        chrSummaries.add(chrSummary);
                        nRows = 0;
                        wgData = new WholeGenomeData(headings);
                    }
                    int location = -1;
                    try {
                        location = Integer.parseInt(tokens[this.startColumn]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        log.info("Location column is not a number.  Skipping row: " + nextLine);
                        continue;
                    }
                    wgData.locations.add(location);
                    if (nTokens > headings.length * skipColumns + this.firstDataColumn) {
                        log.info("Unexpected number of tokens.  Expected " + headings.length + this.firstDataColumn + " found: " + nTokens + "   (" + nextLine + ")");
                    }
                    for (int i = this.firstDataColumn; i < nTokens; i += skipColumns) {
                        int idx = (i - this.firstDataColumn) / skipColumns;
                        float copyNo = Float.NaN;
                        try {
                            copyNo = Float.parseFloat(tokens[i]);
                            dataMin = Math.min(dataMin, copyNo);
                            dataMax = Math.max(dataMax, copyNo);
                        }
                        catch (NumberFormatException e) {
                            // empty catch block
                        }
                        if (copyNo < 0.0f) {
                            logNormalized = true;
                        }
                        String heading = headings[idx];
                        wgData.data.get(heading).add(copyNo);
                    }
                    ++nRows;
                }
                filePosition += (long)nBytes;
            }
            if (chrSummary != null) {
                this.updateWholeGenome(chrSummary.getName(), dataset, headings, wgData);
                chrSummary.setNDataPoints(nRows);
            }
            dataset.setLogNormalized(logNormalized);
            dataset.setDataMin(dataMin);
            dataset.setDataMax(dataMax);
            reader.close();
            return chrSummaries;
        }
        catch (FileNotFoundException e) {
            log.error("CN file not found: " + this.dataResourceLocator);
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            log.error(this.dataResourceLocator.getPath(), e);
            throw new RuntimeException(e);
        }
    }

    public ChromosomeData loadChromosomeData(ChromosomeSummary chrSummary, String[] columnHeaders) {
        try {
            int skipColumns = this.hasCalls ? 2 : 1;
            int nRowsEst = chrSummary.getNDataPts();
            InputStream is = ParsingUtils.openInputStream(this.dataResourceLocator);
            this.position(is, chrSummary.getStartPosition());
            AsciiLineReader reader = new AsciiLineReader(is);
            int nRows = 0;
            String nextLine = reader.readLine();
            IntArrayList startLocations = new IntArrayList(nRowsEst);
            IntArrayList endLocations = this.hasEndLocations ? new IntArrayList(nRowsEst) : null;
            HashMap<String, FloatArrayList> dataMap = new HashMap<String, FloatArrayList>();
            for (String h : columnHeaders) {
                dataMap.put(h, new FloatArrayList(nRowsEst));
            }
            String chromosome = chrSummary.getName();
            boolean chromosomeStarted = false;
            nRows = 0;
            while (nextLine != null && nextLine.trim().length() > 0) {
                block14: {
                    try {
                        int nTokens = ParsingUtils.split(nextLine, tokens, '\t');
                        String thisChromosome = ParsingUtils.convertChrString(this.genomeId, tokens[this.chrColumn].trim());
                        if (thisChromosome.equals(chromosome)) {
                            chromosomeStarted = true;
                            int start = Integer.parseInt(tokens[this.startColumn].trim());
                            if (this.hasEndLocations) {
                                endLocations.add(Integer.parseInt(tokens[this.endColumn].trim()));
                            }
                            startLocations.add(start);
                            for (int i = this.firstDataColumn; i < nTokens; i += skipColumns) {
                                int idx = (i - this.firstDataColumn) / skipColumns;
                                float copyNo = Float.NaN;
                                try {
                                    copyNo = Float.parseFloat(tokens[i].trim());
                                }
                                catch (NumberFormatException e) {
                                    // empty catch block
                                }
                                String heading = columnHeaders[idx];
                                ((FloatArrayList)dataMap.get(heading)).add(copyNo);
                            }
                            ++nRows;
                            break block14;
                        }
                        if (chromosomeStarted) {
                            break;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        log.info("Skipping line (NumberFormatException) " + nextLine);
                    }
                }
                nextLine = reader.readLine();
            }
            ChromosomeData cd = new ChromosomeData(chrSummary.getName());
            cd.setStartLocations(startLocations.toArray());
            if (this.hasEndLocations) {
                cd.setEndLocations(endLocations.toArray());
            }
            for (String h : columnHeaders) {
                cd.setData(h, ((FloatArrayList)dataMap.get(h)).toArray());
            }
            return cd;
        }
        catch (IOException ex) {
            log.error("Error parsing cn file", ex);
            throw new RuntimeException("Error parsing cn file", ex);
        }
    }

    private void parseComment(String comment, IGVDataset dataset) {
        String tmp = comment.substring(1, comment.length());
        if (tmp.startsWith("track")) {
            DatasetParserUtils.parseTrackLine(tmp, dataset.getTrackProperties());
        } else {
            String[] tokens = tmp.split("=");
            if (tokens.length != 2) {
                return;
            }
            String key = tokens[0].trim().toLowerCase();
            if (key.equals("name")) {
                dataset.setName(tokens[1].trim());
            } else if (key.equals("type")) {
                try {
                    dataset.setTrackType(TrackType.valueOf(tokens[1].trim().toUpperCase()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private boolean isCopyNumberFileExt(String filename) {
        String tmp = filename.endsWith(".txt") ? filename.substring(0, filename.length() - 4) : filename;
        return tmp.endsWith(".cn") || tmp.endsWith(".xcn") || tmp.endsWith(".snp");
    }

    public String[] getHeadings(String[] tokens, int skipColumns) {
        int nHeadings = (tokens.length - this.firstDataColumn) / skipColumns;
        String[] headings = new String[nHeadings];
        for (int i = this.firstDataColumn; i < tokens.length; i += skipColumns) {
            int idx = (i - this.firstDataColumn) / skipColumns;
            headings[idx] = tokens[i].trim();
        }
        return headings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int estimateNumberOfRows(String filename) {
        File f = new File(filename);
        BufferedReader reader = null;
        long size = f.length();
        try {
            reader = new BufferedReader(new FileReader(filename));
            String firstLine = reader.readLine();
            int nColumns = firstLine.split("\t").length;
            double factor = filename.toLowerCase().endsWith(".cn") ? 6.0 : 4.4;
            int n = (int)((double)size / ((double)nColumns * factor));
            return n;
        }
        catch (Exception ex) {
            log.error(ex.getMessage());
            int n = 250000;
            return n;
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    private void position(InputStream is, long position) throws IOException {
        if (is instanceof FileInputStream) {
            ((FileInputStream)is).getChannel().position(position);
        } else {
            is.skip(position);
        }
    }

    private void updateWholeGenome(String currentChromosome, IGVDataset dataset, String[] headings, WholeGenomeData sumData) {
        dataset.getGenomeSummary().addLocations(currentChromosome, sumData.locations.toArray());
        for (String h : headings) {
            dataset.getGenomeSummary().addData(h, currentChromosome, sumData.data.get(h).toArray());
        }
    }

    class WholeGenomeData {
        String[] headings;
        IntArrayList locations = new IntArrayList(25000);
        Map<String, FloatArrayList> data = new HashMap<String, FloatArrayList>();

        WholeGenomeData(String[] headings) {
            this.headings = headings;
            for (String h : headings) {
                this.data.put(h, new FloatArrayList(25000));
            }
        }

        int size() {
            return this.locations.size();
        }
    }
}

