/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.data;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.broad.igv.data.ChromosomeData;
import org.broad.igv.data.ChromosomeSummary;
import org.broad.igv.data.Dataset;
import org.broad.igv.data.GenomeSummaryData;
import org.broad.igv.data.IGVDatasetParser;
import org.broad.igv.data.ResourceLocator;
import org.broad.igv.data.TrackProperties;
import org.broad.igv.feature.Genome;
import org.broad.igv.feature.GenomeManager;
import org.broad.igv.track.TrackType;

public class IGVDataset
implements Dataset {
    private String name;
    private TrackType type = TrackType.OTHER;
    private boolean logNormalized;
    private String genomeId;
    private String[] dataHeadings;
    private Map<String, ChromosomeSummary> chromosomeSummaries = new LinkedHashMap<String, ChromosomeSummary>();
    private GenomeSummaryData genomeSummary;
    private IGVDatasetParser parser;
    private float dataMin;
    private float dataMax;
    TrackProperties trackProperties = new TrackProperties();

    public IGVDataset(String genomeId, ResourceLocator locator) {
        this.genomeId = genomeId;
        Genome genome = GenomeManager.getInstance().getGenome(genomeId);
        if (genome == null) {
            throw new RuntimeException("Unknown genome: " + genomeId);
        }
        this.genomeSummary = new GenomeSummaryData(genome);
        this.genomeSummary.setSamplingFreq(1);
        this.parser = new IGVDatasetParser(locator, genomeId);
        List<ChromosomeSummary> summaries = this.parser.scan(this);
        for (ChromosomeSummary summary : summaries) {
            this.chromosomeSummaries.put(summary.getName(), summary);
        }
    }

    public IGVDataset(String genomeId, File file) {
        this(genomeId, new ResourceLocator(file.getAbsolutePath()));
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setTrackType(TrackType type) {
        this.type = type;
    }

    public TrackType getType() {
        return this.type;
    }

    public void setGenome(String genomeId) {
        this.genomeId = genomeId;
    }

    public String getGenome() {
        return this.genomeId;
    }

    public String[] getChromosomes() {
        return this.chromosomeSummaries.keySet().toArray(new String[0]);
    }

    public void setDataHeadings(String[] dataHeadings) {
        this.dataHeadings = dataHeadings;
    }

    public String[] getDataHeadings() {
        return this.dataHeadings;
    }

    public int[] getStartLocations(String chr) {
        ChromosomeData cd = this.getChromosomeData(chr);
        return cd == null ? null : cd.getStartLocations();
    }

    public int[] getEndLocations(String chr) {
        ChromosomeData cd = this.getChromosomeData(chr);
        return cd == null ? null : cd.getEndLocations();
    }

    public String[] getFeatureNames(String chr) {
        return null;
    }

    public int getWindowSpan() {
        return 1;
    }

    public float[] getData(String heading, String chr) {
        ChromosomeData cd = this.getChromosomeData(chr);
        return cd == null ? null : cd.getData(heading);
    }

    private synchronized ChromosomeData getChromosomeData(String chr) {
        ChromosomeSummary sum = this.chromosomeSummaries.get(chr);
        if (sum == null) {
            return null;
        }
        return this.parser.loadChromosomeData(sum, this.dataHeadings);
    }

    public GenomeSummaryData getGenomeSummary() {
        return this.genomeSummary;
    }

    public void setLogNormalized(boolean logNormalized) {
        this.logNormalized = logNormalized;
    }

    public boolean isLogNormalized() {
        return this.logNormalized;
    }

    public float getDataMin() {
        return this.dataMin;
    }

    public float getDataMax() {
        return this.dataMax;
    }

    public void setDataMin(float dataMin) {
        this.dataMin = dataMin;
    }

    public void setDataMax(float dataMax) {
        this.dataMax = dataMax;
    }

    public TrackProperties getTrackProperties() {
        return this.trackProperties;
    }

    public String getColorString() {
        return "0,0,255";
    }
}

