/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.data;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.broad.igv.feature.Genome;

public class GenomeSummaryData {
    long locationUnit = 1000L;
    int samplingFreq = -1;
    Genome genome;
    Map<String, long[]> locationMap = new HashMap<String, long[]>();
    Map<String, Map<String, float[]>> dataMap = new HashMap<String, Map<String, float[]>>();
    int[] locations;

    public GenomeSummaryData(Genome genome) {
        this.genome = genome;
    }

    public void setSamplingFreq(int freq) {
        this.samplingFreq = freq;
    }

    private int getSamplingFreq(int totalSize) {
        if (this.samplingFreq < 0) {
            this.samplingFreq = Math.max(1, totalSize / 100000);
        }
        return this.samplingFreq;
    }

    public void addLocations(String chr, int[] chrLocations) {
        int freq = this.getSamplingFreq(chrLocations.length);
        int len = Math.max(1, chrLocations.length / freq);
        long[] genomeLocations = new long[len];
        for (int i = 0; i < genomeLocations.length; ++i) {
            genomeLocations[i] = chrLocations[i * freq];
        }
        this.locationMap.put(chr, genomeLocations);
    }

    public void addData(String sample, String chr, float[] data) {
        int freq = this.getSamplingFreq(data.length);
        int len = Math.max(1, data.length / freq);
        float[] genomeData = new float[len];
        for (int i = 0; i < genomeData.length; ++i) {
            genomeData[i] = data[i * freq];
        }
        Map<String, float[]> tmp = this.dataMap.get(sample);
        if (tmp == null) {
            tmp = new HashMap<String, float[]>();
            this.dataMap.put(sample, tmp);
        }
        tmp.put(chr, genomeData);
    }

    public int[] getLocations() {
        if (this.locations == null) {
            Collection<String> chrNames = this.genome.getChromosomeNames();
            int nPts = 0;
            for (String chr : chrNames) {
                long[] chrLocs = this.locationMap.get(chr);
                if (chrLocs == null) continue;
                nPts += chrLocs.length;
            }
            this.locations = new int[nPts];
            int index = 0;
            long offset = 0L;
            for (String chr : chrNames) {
                long[] chrLocs = this.locationMap.get(chr);
                if (chrLocs != null) {
                    for (int i = 0; i < chrLocs.length; ++i) {
                        this.locations[index] = (int)((offset + chrLocs[i]) / this.locationUnit);
                        if (this.locations[index] < 0) {
                            System.out.println("Negative location");
                        }
                        ++index;
                    }
                }
                offset += (long)this.genome.getChromosome(chr).getLength();
            }
        }
        return this.locations;
    }

    public float[] getData(String heading) {
        int nPts = this.getLocations().length;
        float[] data = new float[nPts];
        Collection<String> chrNames = this.genome.getChromosomeNames();
        int index = 0;
        for (String chr : chrNames) {
            float[] chrData;
            if (!this.dataMap.containsKey(heading) || (chrData = this.dataMap.get(heading).get(chr)) == null) continue;
            for (int i = 0; i < chrData.length; ++i) {
                data[index] = chrData[i];
                ++index;
            }
        }
        return data;
    }
}

