/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.data;

public class FloatArrayList {
    static final int maxGrowIncrement = 0xCCCCCCC;
    int size = 0;
    float[] values;

    public FloatArrayList(int maxSize) {
        this.values = new float[maxSize];
    }

    public void add(float v) {
        if (this.size >= this.values.length) {
            this.grow();
        }
        this.values[this.size] = v;
        ++this.size;
    }

    public void addAll(float[] array) {
        if (this.values.length - this.size < array.length) {
            this.grow(array.length);
        }
        System.arraycopy(array, 0, this.values, this.size, array.length);
        this.size += array.length;
    }

    public float[] toArray() {
        this.trim();
        return this.values;
    }

    public int getSize() {
        return this.size;
    }

    private void grow() {
        this.grow((int)Math.max(1000.0, 0.2 * (double)this.values.length));
    }

    private void grow(int increment) {
        if (this.values.length >= Integer.MAX_VALUE) {
            throw new RuntimeException("Maximum array size exceeded");
        }
        int newSize = Math.min(Integer.MAX_VALUE, this.values.length + increment);
        this.resize(newSize);
    }

    private void resize(int newSize) {
        float[] tmp = new float[newSize];
        System.arraycopy(this.values, 0, tmp, 0, Math.min(tmp.length, this.values.length));
        this.values = tmp;
    }

    private void trim() {
        this.resize(this.size);
    }

    public void reorder(int[] indeces) {
        if (indeces.length != this.size) {
            throw new IllegalArgumentException("Index array length not equal to size");
        }
        float[] reorderedValues = new float[this.size];
        for (int i = 0; i < this.size; ++i) {
            reorderedValues[i] = this.values[indeces[i]];
        }
        this.values = reorderedValues;
    }
}

