/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools.util;

import net.sf.samtools.util.BinaryCodec;

public class StringUtil {
    public static String join(String separator, String ... strings) {
        if (strings.length == 0) {
            return "";
        }
        StringBuilder ret = new StringBuilder(strings[0]);
        for (int i = 1; i < strings.length; ++i) {
            ret.append(separator);
            ret.append(strings[i]);
        }
        return ret.toString();
    }

    public static int split(String aString, String[] tokens, char delim) {
        String trailingString;
        int maxTokens = tokens.length;
        int nTokens = 0;
        int start = 0;
        int end = aString.indexOf(delim);
        if (end < 0) {
            tokens[nTokens++] = aString;
            return nTokens;
        }
        while (end > 0 && nTokens < maxTokens) {
            tokens[nTokens++] = aString.substring(start, end);
            start = end + 1;
            end = aString.indexOf(delim, start);
        }
        if (nTokens < maxTokens && (trailingString = aString.substring(start)).length() > 0) {
            tokens[nTokens++] = trailingString;
        }
        return nTokens;
    }

    public static byte toUpperCase(byte b) {
        if (b < 97 || b > 122) {
            return b;
        }
        return (byte)(b + -32);
    }

    public static String assertCharactersNotInString(String illegalChars, char ... chars) {
        for (char illegalChar : illegalChars.toCharArray()) {
            for (char ch : chars) {
                if (illegalChar != ch) continue;
                throw new IllegalArgumentException("Supplied String contains illegal character '" + illegalChar + "'.");
            }
        }
        return illegalChars;
    }

    public static String wordWrap(String s, int maxLineLength) {
        String[] lines = s.split("\n");
        StringBuilder sb = new StringBuilder();
        for (String line : lines) {
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(StringUtil.wordWrapSingleLine(line, maxLineLength));
        }
        if (s.endsWith("\n")) {
            sb.append("\n");
        }
        return sb.toString();
    }

    public static String wordWrapSingleLine(String s, int maxLineLength) {
        if (s.length() <= maxLineLength) {
            return s;
        }
        StringBuilder sb = new StringBuilder();
        int startCopyFrom = 0;
        while (startCopyFrom < s.length()) {
            int i;
            int lastSpaceIndex = startCopyFrom;
            for (i = startCopyFrom; i < s.length() && i - startCopyFrom < maxLineLength; ++i) {
                if (!Character.isWhitespace(s.charAt(i))) continue;
                lastSpaceIndex = i;
            }
            if (i - startCopyFrom < maxLineLength) {
                lastSpaceIndex = i;
            }
            while (lastSpaceIndex < s.length() && Character.isWhitespace(s.charAt(lastSpaceIndex))) {
                ++lastSpaceIndex;
            }
            if (sb.length() > 0) {
                sb.append("\n");
            }
            if (lastSpaceIndex == startCopyFrom) {
                lastSpaceIndex = i;
            }
            sb.append(s.substring(startCopyFrom, lastSpaceIndex));
            startCopyFrom = lastSpaceIndex;
        }
        return sb.toString();
    }

    public static String bytesToString(byte[] data) {
        if (data == null) {
            return null;
        }
        return StringUtil.bytesToString(data, 0, data.length);
    }

    public static String bytesToString(byte[] buffer, int offset, int length) {
        return new String(buffer, 0, offset, length);
    }

    public static byte[] stringToBytes(String s) {
        byte[] byteBuffer = new byte[s.length()];
        s.getBytes(0, byteBuffer.length, byteBuffer, 0);
        return byteBuffer;
    }

    public static String readNullTerminatedString(BinaryCodec binaryCodec) {
        StringBuilder ret = new StringBuilder();
        byte b = binaryCodec.readByte();
        while (b != 0) {
            ret.append((char)(b & 0xFF));
            b = binaryCodec.readByte();
        }
        return ret.toString();
    }

    public static void charsToBytes(char[] chars, int charOffset, int length, byte[] bytes, int byteOffset) {
        for (int i = 0; i < length; ++i) {
            bytes[byteOffset + i] = (byte)chars[charOffset + i];
        }
    }
}

