/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools.util;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import net.sf.samtools.util.BinaryCodec;

public class BlockCompressedOutputStream
extends OutputStream {
    private static int defaultCompressionLevel = 5;
    private final BinaryCodec codec;
    private final byte[] uncompressedBuffer = new byte[65536];
    private int numUncompressedBytes = 0;
    private final byte[] compressedBuffer = new byte[65518];
    private final Deflater deflater;
    private final CRC32 crc32 = new CRC32();
    private final byte[] singleByteArray = new byte[1];
    private int numberOfThrottleBacks = 0;

    public static void setDefaultCompressionLevel(int compressionLevel) {
        if (compressionLevel < 1 || compressionLevel > 9) {
            throw new IllegalArgumentException("Invalid compression level: " + compressionLevel);
        }
        defaultCompressionLevel = compressionLevel;
    }

    public BlockCompressedOutputStream(String filename) {
        this(filename, defaultCompressionLevel);
    }

    public BlockCompressedOutputStream(File file) {
        this(file, defaultCompressionLevel);
    }

    public BlockCompressedOutputStream(String filename, int compressionLevel) {
        this.codec = new BinaryCodec(filename, true);
        this.deflater = new Deflater(compressionLevel, true);
    }

    public BlockCompressedOutputStream(File file, int compressionLevel) {
        this.codec = new BinaryCodec(file, true);
        this.deflater = new Deflater(compressionLevel, true);
    }

    public void write(byte[] bytes) throws IOException {
        this.write(bytes, 0, bytes.length);
    }

    public void write(byte[] bytes, int startIndex, int numBytes) throws IOException {
        assert (this.numUncompressedBytes < this.uncompressedBuffer.length);
        while (numBytes > 0) {
            int bytesToWrite = Math.min(this.uncompressedBuffer.length - this.numUncompressedBytes, numBytes);
            System.arraycopy(bytes, startIndex, this.uncompressedBuffer, this.numUncompressedBytes, bytesToWrite);
            this.numUncompressedBytes += bytesToWrite;
            startIndex += bytesToWrite;
            assert ((numBytes -= bytesToWrite) >= 0);
            if (this.numUncompressedBytes != this.uncompressedBuffer.length) continue;
            this.deflateBlock();
        }
    }

    public void flush() throws IOException {
        while (this.numUncompressedBytes > 0) {
            this.deflateBlock();
        }
        this.codec.getOutputStream().flush();
    }

    public void close() throws IOException {
        this.flush();
        if (this.numberOfThrottleBacks > 0) {
            System.err.println("In BlockCompressedOutputStream, had to throttle back " + this.numberOfThrottleBacks + " times for file " + this.codec.getOutputFileName());
        }
        this.codec.close();
    }

    public void write(int bite) throws IOException {
        this.singleByteArray[0] = (byte)bite;
        this.write(this.singleByteArray);
    }

    private int deflateBlock() {
        int compressedSize;
        int bytesToCompress;
        block5: {
            if (this.numUncompressedBytes == 0) {
                return 0;
            }
            bytesToCompress = this.numUncompressedBytes;
            while (true) {
                this.deflater.reset();
                this.deflater.setInput(this.uncompressedBuffer, 0, bytesToCompress);
                this.deflater.finish();
                compressedSize = this.deflater.deflate(this.compressedBuffer, 0, this.compressedBuffer.length);
                if (this.deflater.getBytesRead() >= (long)bytesToCompress) break block5;
                ++this.numberOfThrottleBacks;
                assert ((bytesToCompress -= 1024) > 0);
            }
        }
        this.crc32.reset();
        this.crc32.update(this.uncompressedBuffer, 0, bytesToCompress);
        int totalBlockSize = this.writeGzipBlock(compressedSize, bytesToCompress, this.crc32.getValue());
        assert (bytesToCompress <= this.numUncompressedBytes);
        if (bytesToCompress == this.numUncompressedBytes) {
            this.numUncompressedBytes = 0;
        } else {
            System.arraycopy(this.uncompressedBuffer, bytesToCompress, this.uncompressedBuffer, 0, this.numUncompressedBytes - bytesToCompress);
            this.numUncompressedBytes -= bytesToCompress;
        }
        return totalBlockSize;
    }

    private int writeGzipBlock(int compressedSize, int uncompressedSize, long crc) {
        this.codec.writeByte((byte)31);
        this.codec.writeByte(139);
        this.codec.writeByte((byte)8);
        this.codec.writeByte(4);
        this.codec.writeInt(0);
        this.codec.writeByte(0);
        this.codec.writeByte(255);
        this.codec.writeShort((short)6);
        this.codec.writeByte((byte)66);
        this.codec.writeByte((byte)67);
        this.codec.writeShort((short)2);
        int totalBlockSize = compressedSize + 18 + 8;
        this.codec.writeShort((short)(totalBlockSize - 1));
        this.codec.writeBytes(this.compressedBuffer, 0, compressedSize);
        this.codec.writeInt((int)crc);
        this.codec.writeInt(uncompressedSize);
        return totalBlockSize;
    }
}

