/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools;

import java.util.Map;
import net.sf.samtools.BinaryTagCodec;
import net.sf.samtools.SAMFormatException;
import net.sf.samtools.SAMUtils;
import net.sf.samtools.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TextTagCodec {
    private static final int NUM_TAG_FIELDS = 3;
    private final String[] fields = new String[3];
    private final String[] typeAndValueFields = new String[2];

    TextTagCodec() {
    }

    String encode(String tagName, Object value) {
        StringBuilder sb = new StringBuilder(tagName);
        sb.append(':');
        char tagType = BinaryTagCodec.getTagValueType(value);
        switch (tagType) {
            case 'C': 
            case 'I': 
            case 'S': 
            case 'c': 
            case 's': {
                tagType = 'i';
            }
        }
        if (tagType == 'H') {
            value = SAMUtils.bytesToHexString((byte[])value);
        }
        sb.append(tagType);
        sb.append(':');
        sb.append(value.toString());
        return sb.toString();
    }

    String encodeUntypedTag(String tagName, Object value) {
        StringBuilder sb = new StringBuilder(tagName);
        sb.append(':');
        sb.append(value.toString());
        return sb.toString();
    }

    Map.Entry<String, Object> decode(String tag) {
        int numFields = StringUtil.split(tag, this.fields, ':');
        if (numFields != 3) {
            throw new SAMFormatException("Not enough fields in tag '" + tag + "'");
        }
        final String key = this.fields[0];
        String type = this.fields[1];
        String stringVal = this.fields[2];
        final Object val = this.convertStringToObject(type, stringVal);
        return new Map.Entry<String, Object>(){

            @Override
            public String getKey() {
                return key;
            }

            @Override
            public Object getValue() {
                return val;
            }

            @Override
            public Object setValue(Object o) {
                throw new UnsupportedOperationException();
            }
        };
    }

    Object decodeTypeAndValue(String typeAndValue) {
        int numFields = StringUtil.split(typeAndValue, this.typeAndValueFields, ':');
        if (numFields == 1) {
            return typeAndValue;
        }
        return this.convertStringToObject(this.typeAndValueFields[0], this.typeAndValueFields[1]);
    }

    private Object convertStringToObject(String type, String stringVal) {
        Object val;
        if (type.equals("Z")) {
            val = stringVal;
        } else if (type.equals("A")) {
            if (stringVal.length() != 1) {
                throw new SAMFormatException("Tag of type A should have a single-character value");
            }
            val = Character.valueOf(stringVal.charAt(0));
        } else if (type.equals("i")) {
            try {
                val = new Integer(stringVal);
            }
            catch (NumberFormatException e) {
                throw new SAMFormatException("Tag of type i should have signed decimal value");
            }
        } else if (type.equals("f")) {
            try {
                val = new Float(stringVal);
            }
            catch (NumberFormatException e) {
                throw new SAMFormatException("Tag of type f should have single-precision floating point value");
            }
        } else if (type.equals("H")) {
            try {
                val = SAMUtils.hexStringToBytes(stringVal);
            }
            catch (NumberFormatException e) {
                throw new SAMFormatException("Tag of type H should have valid hex string with even number of digits");
            }
        } else {
            throw new SAMFormatException("Unrecognized tag type: " + type);
        }
        return val;
    }
}

