/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.sf.samtools.AbstractSAMHeaderRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SAMSequenceRecord
extends AbstractSAMHeaderRecord {
    private String mSequenceName = null;
    private int mSequenceIndex = -1;
    private int mSequenceLength = 0;
    public static final String SEQUENCE_NAME_TAG = "SN";
    public static final String SEQUENCE_LENGTH_TAG = "LN";
    public static final String MD5_TAG = "M5";
    public static final String ASSEMBLY_TAG = "AS";
    public static final String URI_TAG = "UR";
    public static final String SPECIES_TAG = "SP";
    public static final Set<String> STANDARD_TAGS = new HashSet<String>(Arrays.asList("SN", "LN", "AS", "M5", "UR", "SP"));

    public SAMSequenceRecord(String name) {
        this.mSequenceName = name;
    }

    public SAMSequenceRecord(String name, int sequenceLength) {
        this.mSequenceName = name;
        this.mSequenceLength = sequenceLength;
    }

    public String getSequenceName() {
        return this.mSequenceName;
    }

    public int getSequenceLength() {
        return this.mSequenceLength;
    }

    public void setSequenceLength(int value) {
        this.mSequenceLength = value;
    }

    public String getAssembly() {
        return (String)this.getAttribute(ASSEMBLY_TAG);
    }

    public void setAssembly(String value) {
        this.setAttribute(ASSEMBLY_TAG, value);
    }

    public String getSpecies() {
        return (String)this.getAttribute(SPECIES_TAG);
    }

    public void setSpecies(String value) {
        this.setAttribute(SPECIES_TAG, value);
    }

    public int getSequenceIndex() {
        return this.mSequenceIndex;
    }

    void setSequenceIndex(int value) {
        this.mSequenceIndex = value;
    }

    public boolean isSameSequence(SAMSequenceRecord that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (this.mSequenceIndex != that.mSequenceIndex) {
            return false;
        }
        if (this.mSequenceLength != that.mSequenceLength) {
            return false;
        }
        if (this.mSequenceName != null ? !this.mSequenceName.equals(that.mSequenceName) : that.mSequenceName != null) {
            return false;
        }
        for (Map.Entry<String, Object> entry : this.getAttributes()) {
            BigInteger thatMd5;
            BigInteger thisMd5;
            Object thatAttribute = that.getAttribute(entry.getKey());
            if (thatAttribute == null || !(entry.getKey().equals(MD5_TAG) ? !(thisMd5 = new BigInteger((String)entry.getValue(), 16)).equals(thatMd5 = new BigInteger((String)thatAttribute, 16)) : !entry.getValue().equals(thatAttribute))) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SAMSequenceRecord)) {
            return false;
        }
        SAMSequenceRecord that = (SAMSequenceRecord)o;
        if (this.mSequenceIndex != that.mSequenceIndex) {
            return false;
        }
        if (this.mSequenceLength != that.mSequenceLength) {
            return false;
        }
        if (!this.attributesEqual(that)) {
            return false;
        }
        return !(this.mSequenceName != null ? !this.mSequenceName.equals(that.mSequenceName) : that.mSequenceName != null);
    }

    public int hashCode() {
        int result = this.mSequenceName != null ? this.mSequenceName.hashCode() : 0;
        result = 31 * result + this.mSequenceIndex;
        result = 31 * result + this.mSequenceLength;
        result = 31 * result + this.attributesHashCode();
        return result;
    }

    @Override
    Set<String> getStandardTags() {
        return STANDARD_TAGS;
    }
}

