/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.sf.samtools.AbstractSAMHeaderRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SAMReadGroupRecord
extends AbstractSAMHeaderRecord {
    private String mReadGroupId = null;
    public static final String READ_GROUP_ID_TAG = "ID";
    public static final String READ_GROUP_SAMPLE_TAG = "SM";
    public static final String PREDICTED_MEDIAN_INSERT_SIZE_TAG = "PI";
    public static final String DATE_RUN_PRODUCED_TAG = "DT";
    public static final String DESCRIPTION_TAG = "DS";
    public static final String PLATFORM_UNIT_TAG = "PU";
    public static final String SEQUENCING_CENTER_TAG = "CN";
    public static final String PLATFORM_TAG = "PL";
    public static final String LIBRARY_TAG = "LB";
    public static final Set<String> STANDARD_TAGS = new HashSet<String>(Arrays.asList("ID", "SM", "LB", "DS", "PU", "PI", "CN", "DT", "PL"));

    public SAMReadGroupRecord(String id) {
        this.mReadGroupId = id;
    }

    public String getReadGroupId() {
        return this.mReadGroupId;
    }

    public String getSample() {
        return (String)this.getAttribute(READ_GROUP_SAMPLE_TAG);
    }

    public void setSample(String value) {
        this.setAttribute(READ_GROUP_SAMPLE_TAG, value);
    }

    public String getLibrary() {
        return (String)this.getAttribute(LIBRARY_TAG);
    }

    public void setLibrary(String value) {
        this.setAttribute(LIBRARY_TAG, value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SAMReadGroupRecord that = (SAMReadGroupRecord)o;
        if (!this.attributesEqual(that)) {
            return false;
        }
        return !(this.mReadGroupId != null ? !this.mReadGroupId.equals(that.mReadGroupId) : that.mReadGroupId != null);
    }

    public int hashCode() {
        int result = this.mReadGroupId != null ? this.mReadGroupId.hashCode() : 0;
        result = 31 * result + this.attributesHashCode();
        return result;
    }

    @Override
    Set<String> getStandardTags() {
        return STANDARD_TAGS;
    }
}

