/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools;

import java.io.DataOutputStream;
import java.io.File;
import net.sf.samtools.BAMFileConstants;
import net.sf.samtools.BAMRecordCodec;
import net.sf.samtools.SAMFileWriterImpl;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMSequenceRecord;
import net.sf.samtools.util.BinaryCodec;
import net.sf.samtools.util.BlockCompressedOutputStream;

class BAMFileWriter
extends SAMFileWriterImpl {
    private final BinaryCodec outputBinaryCodec;
    private BAMRecordCodec bamRecordCodec = null;

    public BAMFileWriter(File path) {
        this.outputBinaryCodec = new BinaryCodec(new DataOutputStream(new BlockCompressedOutputStream(path)));
        this.outputBinaryCodec.setOutputFileName(path.toString());
    }

    public BAMFileWriter(File path, int compressionLevel) {
        this.outputBinaryCodec = new BinaryCodec(new DataOutputStream(new BlockCompressedOutputStream(path, compressionLevel)));
        this.outputBinaryCodec.setOutputFileName(path.toString());
    }

    private void prepareToWriteAlignments() {
        if (this.bamRecordCodec == null) {
            this.bamRecordCodec = new BAMRecordCodec(this.getHeader());
            this.bamRecordCodec.setOutputStream(this.outputBinaryCodec.getOutputStream());
        }
    }

    protected void writeAlignment(SAMRecord alignment) {
        this.prepareToWriteAlignments();
        this.bamRecordCodec.encode(alignment);
    }

    protected void writeHeader(String textHeader) {
        this.outputBinaryCodec.writeBytes(BAMFileConstants.BAM_MAGIC);
        this.outputBinaryCodec.writeString(textHeader, true, false);
        this.outputBinaryCodec.writeInt(this.getHeader().getSequenceDictionary().size());
        for (SAMSequenceRecord sequenceRecord : this.getHeader().getSequenceDictionary().getSequences()) {
            this.outputBinaryCodec.writeString(sequenceRecord.getSequenceName(), true, true);
            this.outputBinaryCodec.writeInt(sequenceRecord.getSequenceLength());
        }
    }

    protected void finish() {
        this.outputBinaryCodec.close();
    }

    protected String getFilename() {
        return this.outputBinaryCodec.getOutputFileName();
    }
}

