/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util;

import java.util.Comparator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeapSort {
    private static int left(int i) {
        return 2 * i + 1;
    }

    private static int right(int i) {
        return 2 * i + 2;
    }

    public static <T> void sort(List<T> list, Comparator<T> c) {
        HeapSort.sort(list, 0, list.size() - 1, c);
    }

    static <T> void sort(List<T> list, int lo0, int hi0, Comparator<T> c) {
        T temp;
        int r;
        int l;
        int i;
        int largest;
        int sortsize = list.size();
        if (sortsize <= 1) {
            return;
        }
        int top = sortsize - 1;
        int t = sortsize / 2;
        do {
            largest = --t;
            do {
                i = largest;
                l = HeapSort.left(largest);
                r = HeapSort.right(largest);
                if (l <= top && c.compare(list.get(l), list.get(i)) > 0) {
                    largest = l;
                }
                if (r <= top && c.compare(list.get(r), list.get(largest)) > 0) {
                    largest = r;
                }
                if (largest == i) continue;
                temp = list.get(largest);
                list.set(largest, list.get(i));
                list.set(i, temp);
            } while (largest != i);
        } while (t > 0);
        t = sortsize;
        do {
            --top;
            int here = --t;
            temp = list.get(here);
            list.set(here, list.get(0));
            list.set(0, temp);
            largest = 0;
            do {
                i = largest;
                l = HeapSort.left(largest);
                r = HeapSort.right(largest);
                if (l <= top && c.compare(list.get(l), list.get(i)) > 0) {
                    largest = l;
                }
                if (r <= top && c.compare(list.get(r), list.get(largest)) > 0) {
                    largest = r;
                }
                if (largest == i) continue;
                temp = list.get(largest);
                list.set(largest, list.get(i));
                list.set(i, temp);
            } while (largest != i);
        } while (t > 1);
    }

    static void sort(int[] array, int lo0, int hi0, Comparator<Integer> c) {
        Integer temp;
        int r;
        int l;
        int i;
        int largest;
        int sortsize = array.length;
        if (sortsize <= 1) {
            return;
        }
        int top = sortsize - 1;
        int t = sortsize / 2;
        do {
            largest = --t;
            do {
                i = largest;
                l = HeapSort.left(largest);
                r = HeapSort.right(largest);
                if (l <= top && c.compare(array[l], array[i]) > 0) {
                    largest = l;
                }
                if (r <= top && c.compare(array[r], array[largest]) > 0) {
                    largest = r;
                }
                if (largest == i) continue;
                temp = array[largest];
                array[largest] = array[i];
                array[i] = array[temp];
            } while (largest != i);
        } while (t > 0);
        t = sortsize;
        do {
            --top;
            int here = --t;
            temp = array[here];
            array[here] = array[0];
            array[0] = array[temp];
            largest = 0;
            do {
                i = largest;
                l = HeapSort.left(largest);
                r = HeapSort.right(largest);
                if (l <= top && c.compare(array[l], array[i]) > 0) {
                    largest = l;
                }
                if (r <= top && c.compare(array[r], array[largest]) > 0) {
                    largest = r;
                }
                if (largest == i) continue;
                temp = array[largest];
                array[largest] = array[i];
                array[i] = array[temp];
            } while (largest != i);
        } while (t > 1);
    }
}

