/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;

public class AsciiLineReader {
    InputStream is;
    byte[] buffer;
    int nextChar;
    int nChars;
    char[] lineBuffer;

    public AsciiLineReader(InputStream is) {
        this(is, 512000);
    }

    public AsciiLineReader(InputStream is, int bufferSize) {
        this.is = is;
        this.buffer = new byte[bufferSize];
        this.nChars = 0;
        this.nextChar = 0;
        this.lineBuffer = new char[10000];
    }

    public String readLine() throws IOException {
        return this.readLine(false);
    }

    public String readLine(boolean includeTerminators) throws IOException {
        int linePosition = 0;
        while (this.nChars != -1) {
            char c;
            if (this.nextChar == this.nChars) {
                this.fill();
                if (this.nextChar == this.nChars || this.nChars == -1) {
                    if (linePosition > 0) {
                        return new String(this.lineBuffer, 0, linePosition);
                    }
                    return null;
                }
            }
            if ((c = (char)(this.buffer[this.nextChar++] & 0xFF)) == '\n' || c == '\r') {
                if (includeTerminators) {
                    this.lineBuffer[linePosition++] = c;
                    if (c == '\r' && this.peek() == '\n') {
                        this.lineBuffer[linePosition++] = c;
                        ++this.nextChar;
                    }
                } else if (c == '\r' && this.peek() == '\n') {
                    ++this.nextChar;
                }
                return new String(this.lineBuffer, 0, linePosition);
            }
            if (linePosition > this.lineBuffer.length - 3) {
                char[] temp = new char[this.lineBuffer.length + 1000];
                System.arraycopy(this.lineBuffer, 0, temp, 0, this.lineBuffer.length);
                this.lineBuffer = temp;
            }
            this.lineBuffer[linePosition++] = c;
        }
        return null;
    }

    private char peek() throws IOException {
        if (this.nextChar == this.nChars) {
            this.fill();
            if (this.nextChar == this.nChars) {
                return '\u0000';
            }
        }
        return (char)this.buffer[this.nextChar];
    }

    private void fill() throws IOException {
        this.nChars = this.is.read(this.buffer);
        this.nextChar = 0;
    }

    public void close() throws IOException {
        this.is.close();
    }

    public static void main(String[] args) throws Exception {
        File testFile = new File("/Users/jrobinso/IGV/TestData/NCLE_RNA_12345_RMA.gct");
        AsciiLineReader reader = new AsciiLineReader(new FileInputStream(testFile));
        BufferedReader reader2 = new BufferedReader(new FileReader(testFile));
        long t0 = System.currentTimeMillis();
        long lineCount = 0L;
        while (reader.readLine() != null) {
            ++lineCount;
        }
        long dt = System.currentTimeMillis() - t0;
        double rate = (double)lineCount / (double)dt;
        System.out.println("AS: read rate" + rate + "  DT = " + dt);
        reader.close();
        t0 = System.currentTimeMillis();
        lineCount = 0L;
        while (reader2.readLine() != null) {
            ++lineCount;
        }
        dt = System.currentTimeMillis() - t0;
        rate = (double)lineCount / (double)dt;
        System.out.println("BR: read rate" + rate + "  DT = " + dt);
        reader2.close();
    }
}

