/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.preprocess;

import java.io.File;
import java.io.IOException;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.util.CloseableIterator;
import org.broad.igv.preprocess.Alignment;
import org.broad.igv.preprocess.AlignmentFileIterator;

public class SAMFileIterator
implements AlignmentFileIterator {
    CloseableIterator<SAMRecord> iter;
    Alignment nextAlignment;

    public SAMFileIterator(File file) {
        SAMFileReader reader = new SAMFileReader(file);
        reader.setValidationStringency(SAMFileReader.ValidationStringency.SILENT);
        this.iter = reader.iterator();
        this.advance();
    }

    private void advance() {
        if (this.iter.hasNext()) {
            SAMRecord record = (SAMRecord)this.iter.next();
            this.nextAlignment = new Alignment(record.getReferenceName(), record.getAlignmentStart(), record.getAlignmentEnd(), record.getReadNegativeStrandFlag());
            this.nextAlignment.setMappingQuality(record.getMappingQuality());
            this.nextAlignment.setDuplicate(record.getDuplicateReadFlag());
        } else {
            this.nextAlignment = null;
        }
    }

    public boolean hasNext() {
        return this.nextAlignment != null;
    }

    public Alignment next() throws IOException {
        Alignment retValue = this.nextAlignment;
        this.advance();
        return retValue;
    }

    public void close() throws IOException {
        this.iter.close();
    }
}

