/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.preprocess;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.broad.igv.feature.Genome;
import org.broad.igv.feature.GenomeManager;
import org.broad.igv.preprocess.Alignment;
import org.broad.igv.preprocess.AlignmentFileIterator;
import org.broad.igv.preprocess.MAQFileIterator;
import org.broad.igv.preprocess.SAMFileIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadCounter {
    File samFile;

    public ReadCounter(File file) {
        this.samFile = file;
    }

    private AlignmentFileIterator getIterator(File f) throws IOException {
        String fn = f.getName().toLowerCase();
        if (fn.endsWith(".sam") || fn.endsWith(".bam")) {
            return new SAMFileIterator(f);
        }
        return new MAQFileIterator(f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Counts doReadCounts(int resolution, int extensionFactor, String genomeId, Map<String, Integer> lastPositionPerChr) {
        int progressStep = 1000000;
        boolean progressIncrement = true;
        long cnt = 0L;
        float avgReadLength = 0.0f;
        Genome genome = genomeId == null ? null : GenomeManager.getInstance().getGenome(genomeId);
        HashMap<String, short[]> readCountMap = new HashMap<String, short[]>();
        AlignmentFileIterator iter = null;
        try {
            iter = this.getIterator(this.samFile);
            while (iter.hasNext()) {
                Alignment record = iter.next();
                if (record.isDuplicate() || record.getMappingQuality() <= 0) continue;
                String chr = record.getChr();
                int start = record.getStart();
                int end = record.getEnd();
                avgReadLength += (float)(end - start);
                ++cnt;
                if (record.isIsNegative()) {
                    start = Math.max(0, start - extensionFactor);
                } else {
                    end += extensionFactor;
                }
                int lastPosition = lastPositionPerChr.containsKey(chr) ? lastPositionPerChr.get(chr) : 0;
                lastPosition = Math.max(lastPosition, end);
                lastPositionPerChr.put(chr, lastPosition);
                short[] counts = (short[])readCountMap.get(chr);
                if (counts == null) {
                    int chrLength = 250000000;
                    if (genome != null && genome.getChromosome(chr) != null) {
                        chrLength = genome.getChromosome(chr).getLength();
                    }
                    int nPoints = (int)(1.1 * (double)chrLength / (double)resolution);
                    counts = new short[nPoints];
                    readCountMap.put(chr, counts);
                }
                int maxIndex = counts.length - 1;
                int startIndex = Math.min(maxIndex, start / resolution);
                int endIndex = Math.min(maxIndex, end / resolution);
                int i = startIndex;
                while (i <= endIndex) {
                    int n = i++;
                    counts[n] = (short)(counts[n] + 1);
                }
            }
            if (cnt > 0L) {
                avgReadLength /= (float)cnt;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                iter.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return new Counts(readCountMap, cnt, avgReadLength);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Counts {
        Map<String, short[]> countsPreChr;
        long totalReadCount;
        float avgReadLength;

        public Counts(Map<String, short[]> countsPreChr, long totalReadCount, float avgReadLength) {
            this.countsPreChr = countsPreChr;
            this.totalReadCount = totalReadCount;
            this.avgReadLength = avgReadLength;
        }
    }
}

