/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.preprocess;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class EndianConverter {
    public static int convert(byte[] srcBuffer, short[] destBuffer, int srcLength, int destOffset, int destLength) {
        return EndianConverter.convert(srcBuffer, destBuffer, srcLength, destOffset, destLength, (short)255);
    }

    public static int convert(byte[] srcBuffer, short[] destBuffer, int srcLength, int destOffset, int destLength, short mask) {
        srcLength = Math.min(destLength * 2, srcLength / 2 * 2);
        for (int i = 0; i < srcLength; i += 2) {
            int tmp = (srcBuffer[i] & 0xFF | srcBuffer[i + 1] << 8) & mask;
            destBuffer[i / 2 + destOffset] = (short)tmp;
        }
        return srcLength;
    }

    public static int convert(byte[] srcBuffer, int[] destBuffer, int srcLength, int destOffset, int destLength) {
        return EndianConverter.convert(srcBuffer, destBuffer, srcLength, destOffset, destLength, -1);
    }

    public static int convert(byte[] srcBuffer, int[] destBuffer, int srcLength, int destOffset, int destLength, int mask) {
        srcLength = Math.min(destLength * 4, srcLength / 4 * 4);
        for (int i = 0; i < srcLength; i += 4) {
            destBuffer[i / 4 + destOffset] = (srcBuffer[i] & 0xFF | srcBuffer[i + 1] << 8 & 0xFF00 | srcBuffer[i + 2] << 16 & 0xFF0000 | srcBuffer[i + 3] << 24) & mask;
        }
        return srcLength;
    }

    public static int convert(byte[] srcBuffer, long[] destBuffer, int srcLength, int destOffset, int destLength) {
        return EndianConverter.convert(srcBuffer, destBuffer, srcLength, destOffset, destLength, -1L);
    }

    public static int convert(byte[] srcBuffer, long[] destBuffer, int srcLength, int destOffset, int destLength, long mask) {
        srcLength = Math.min(destLength * 8, srcLength / 8 * 8);
        for (int i = 0; i < srcLength; i += 8) {
            destBuffer[i / 8 + destOffset] = ((long)(srcBuffer[i] & 0xFF | srcBuffer[i + 1] << 8 & 0xFF00 | srcBuffer[i + 2] << 16 & 0xFF0000 | srcBuffer[i + 3] << 24 & 0xFF000000) | (long)(srcBuffer[i + 3] << 32) & 0xFF00000000L | (long)(srcBuffer[i + 5] << 40) & 0xFF0000000000L | (long)(srcBuffer[i + 6] << 48) & 0xFF000000000000L | (long)(srcBuffer[i + 7] << 56)) & mask;
        }
        return srcLength;
    }

    public static short convert(short value) {
        return (short)(value >> 8 & 0xFF | value << 8);
    }

    public static int convert(int value) {
        return value >> 24 & 0xFF | value >> 8 & 0xFF00 | value << 8 & 0xFF0000 | value << 24;
    }

    public static long convert(long value) {
        return value >> 56 & 0xFFL | value >> 40 & 0xFF00L | value >> 24 & 0xFF0000L | value >> 8 & 0xFFFFFFFFFF000000L | value << 8 & 0xFF00000000L | value << 24 & 0xFF00000000L | value << 56 & 0xFF0000000000L;
    }

    public static int convertLittleEndianToFloat(byte[] srcBuffer, float[] destBuffer, int srcLength, int destOffset, int destLength) {
        srcLength = Math.min(destLength * 4, srcLength / 4 * 4);
        for (int i = 0; i < srcLength; i += 4) {
            destBuffer[i / 4 + destOffset] = Float.intBitsToFloat(srcBuffer[i] & 0xFF | srcBuffer[i + 1] << 8 & 0xFF00 | srcBuffer[i + 2] << 16 & 0xFF0000 | srcBuffer[i + 3] << 24);
        }
        return srcLength;
    }

    public static int convertLittleEndianToDouble(byte[] srcBuffer, double[] destBuffer, int srcLength, int destOffset, int destLength) {
        srcLength = Math.min(destLength * 8, srcLength / 8 * 8);
        for (int i = 0; i < srcLength; i += 8) {
            destBuffer[i / 8 + destOffset] = Double.longBitsToDouble((long)(srcBuffer[i] & 0xFF | srcBuffer[i + 1] << 8 & 0xFF00 | srcBuffer[i + 2] << 16 & 0xFF0000 | srcBuffer[i + 3] << 24 & 0xFF000000) | (long)(srcBuffer[i + 3] << 32) & 0xFF00000000L | (long)(srcBuffer[i + 5] << 40) & 0xFF0000000000L | (long)(srcBuffer[i + 6] << 48) & 0xFF000000000000L | (long)(srcBuffer[i + 7] << 56));
        }
        return srcLength;
    }

    public static int convert(int blockSize, byte[] srcBuffer, int[] destBuffer, int srcLength, int destOffset, int destLength) {
        return EndianConverter.convert(blockSize, srcBuffer, destBuffer, srcLength, destOffset, destLength, -1);
    }

    public static int convert(int blockSize, byte[] srcBuffer, int[] destBuffer, int srcLength, int destOffset, int destLength, int mask) {
        int length = Math.min(destLength * blockSize, srcLength / blockSize * blockSize);
        if (blockSize == 2) {
            for (int i = 0; i < length; i += 2) {
                destBuffer[i / 2 + destOffset] = (srcBuffer[i] & 0xFF | srcBuffer[i + 1] << 8) & mask;
            }
            return length;
        }
        if (blockSize == 3) {
            for (int i = 0; i < length; i += 3) {
                destBuffer[i / 3 + destOffset] = (srcBuffer[i] & 0xFF | srcBuffer[i + 1] << 8 & 0xFF00 | srcBuffer[i + 2] << 24) & mask;
            }
            return length;
        }
        if (blockSize == 4) {
            return EndianConverter.convert(srcBuffer, destBuffer, srcLength, destOffset, destLength, mask);
        }
        return 0;
    }

    public static int convertToLittleEndian(short[] srcBuffer, byte[] destBuffer, int srcOffset, int srcLength) {
        srcLength = Math.min(srcLength, destBuffer.length / 2);
        int index = 0;
        for (int i = 0; i < srcLength; ++i) {
            short data = srcBuffer[srcOffset + i];
            destBuffer[index++] = (byte)data;
            destBuffer[index++] = (byte)(data >> 8);
        }
        return srcLength;
    }

    public static int convertToLittleEndian(int[] srcBuffer, byte[] destBuffer, int srcOffset, int srcLength) {
        srcLength = Math.min(srcLength, destBuffer.length / 4);
        int index = 0;
        for (int i = 0; i < srcLength; ++i) {
            int data = srcBuffer[srcOffset + i];
            destBuffer[index++] = (byte)data;
            destBuffer[index++] = (byte)(data >> 8);
            destBuffer[index++] = (byte)(data >> 16);
            destBuffer[index++] = (byte)(data >> 24);
        }
        return srcLength;
    }

    public static int convertToLittleEndian(int blockSize, int[] srcBuffer, byte[] destBuffer, int srcOffset, int srcLength) {
        srcLength = Math.min(srcLength, destBuffer.length / blockSize);
        int index = 0;
        for (int i = 0; i < srcLength; ++i) {
            int data = srcBuffer[srcOffset + i];
            destBuffer[index++] = (byte)data;
            if (blockSize < 2) continue;
            destBuffer[index++] = (byte)(data >> 8);
            if (blockSize < 3) continue;
            destBuffer[index++] = (byte)(data >> 16);
            if (blockSize != 4) continue;
            destBuffer[index++] = (byte)(data >> 24);
        }
        return srcLength;
    }

    public static int convertToLittleEndian(long[] srcBuffer, byte[] destBuffer, int srcOffset, int srcLength) {
        srcLength = Math.min(srcLength, destBuffer.length / 8);
        int index = 0;
        for (int i = 0; i < srcLength; ++i) {
            long data = srcBuffer[srcOffset + i];
            for (int j = 0; j < 8; ++j) {
                destBuffer[index++] = (byte)data;
                data >>= 8;
            }
        }
        return srcLength;
    }

    public static int convertToLittleEndian(float[] srcBuffer, byte[] destBuffer, int srcOffset, int srcLength) {
        srcLength = Math.min(srcLength, destBuffer.length / 4);
        int index = 0;
        for (int i = 0; i < srcLength; ++i) {
            int data = Float.floatToIntBits(srcBuffer[srcOffset + i]);
            destBuffer[index++] = (byte)data;
            destBuffer[index++] = (byte)(data >> 8);
            destBuffer[index++] = (byte)(data >> 16);
            destBuffer[index++] = (byte)(data >> 24);
        }
        return srcLength;
    }

    public static int convertToLittleEndian(double[] srcBuffer, byte[] destBuffer, int srcOffset, int srcLength) {
        srcLength = Math.min(srcLength, destBuffer.length / 8);
        int index = 0;
        for (int i = 0; i < srcLength; ++i) {
            long data = Double.doubleToLongBits(srcBuffer[srcOffset + i]);
            for (int j = 0; j < 8; ++j) {
                destBuffer[index++] = (byte)data;
                data >>= 8;
            }
        }
        return srcLength;
    }

    public static int read(byte[] readBuffer, short[] destBuffer, int destOffset, int destLength, InputStream stream) throws IOException {
        return EndianConverter.read(readBuffer, destBuffer, destOffset, destLength, stream, (short)255);
    }

    public static int read(byte[] readBuffer, short[] destBuffer, int destOffset, int destLength, InputStream stream, short mask) throws IOException {
        int numOfData;
        int numOfProcessedBytes;
        int numOfBytesRead = 0;
        int offset = 0;
        int length = readBuffer.length / 2 * 2;
        for (numOfData = 0; numOfBytesRead >= 0 && numOfData < destLength; numOfData += numOfProcessedBytes / 2) {
            int maxBytesToRead = Math.min((destLength - numOfData) * 2, length);
            numOfBytesRead = stream.read(readBuffer, offset, maxBytesToRead - offset);
            if (numOfBytesRead - (numOfProcessedBytes = EndianConverter.convert(readBuffer, destBuffer, numOfBytesRead + offset, destOffset + numOfData, destLength - numOfData, mask)) == 1) {
                offset = 1;
                readBuffer[0] = readBuffer[numOfProcessedBytes];
                continue;
            }
            offset = 0;
        }
        return numOfData;
    }

    public static int read(byte[] readBuffer, int[] destBuffer, int destOffset, int destLength, InputStream stream) throws IOException {
        return EndianConverter.read(readBuffer, destBuffer, destOffset, destLength, stream, -1);
    }

    public static int read(byte[] readBuffer, int[] destBuffer, int destOffset, int destLength, InputStream stream, int mask) throws IOException {
        int numOfData;
        int numOfProcessedBytes;
        int numOfBytesRead = 0;
        int offset = 0;
        int length = readBuffer.length / 4 * 4;
        for (numOfData = 0; numOfBytesRead >= 0 && numOfData < destLength; numOfData += numOfProcessedBytes / 4) {
            int maxBytesToRead = Math.min((destLength - numOfData) * 4, length);
            numOfBytesRead = stream.read(readBuffer, offset, maxBytesToRead - offset);
            if ((offset = numOfBytesRead - (numOfProcessedBytes = EndianConverter.convert(readBuffer, destBuffer, numOfBytesRead + offset, destOffset + numOfData, destLength - numOfData, mask))) < 1) continue;
            readBuffer[0] = readBuffer[numOfProcessedBytes];
            if (offset < 2) continue;
            readBuffer[1] = readBuffer[numOfProcessedBytes + 1];
            if (offset < 3) continue;
            readBuffer[2] = readBuffer[numOfProcessedBytes + 2];
        }
        return numOfData;
    }

    public static int read(int blockSize, byte[] readBuffer, int[] destBuffer, int destOffset, int destLength, InputStream stream) throws IOException {
        return EndianConverter.read(blockSize, readBuffer, destBuffer, destOffset, destLength, stream, -1);
    }

    public static int read(int blockSize, byte[] readBuffer, int[] destBuffer, int destOffset, int destLength, InputStream stream, int mask) throws IOException {
        if (blockSize == 2) {
            return EndianConverter.read2ByteBlock(readBuffer, destBuffer, destOffset, destLength, stream, mask);
        }
        if (blockSize == 3) {
            return EndianConverter.read3ByteBlock(readBuffer, destBuffer, destOffset, destLength, stream, mask);
        }
        if (blockSize == 4) {
            return EndianConverter.read(readBuffer, destBuffer, destOffset, destLength, stream, mask);
        }
        return 0;
    }

    public static int read4ByteBlock(InputStream stream) throws IOException {
        return EndianConverter.read(stream) & 0xFF | EndianConverter.read(stream) << 8 & 0xFF00 | EndianConverter.read(stream) << 16 & 0xFF0000 | EndianConverter.read(stream) << 24;
    }

    public static int read2ByteBlock(InputStream stream) throws IOException {
        return EndianConverter.read(stream) & 0xFF | EndianConverter.read(stream) << 8;
    }

    public static int read3ByteBlock(InputStream stream) throws IOException {
        return EndianConverter.read(stream) & 0xFF | EndianConverter.read(stream) << 8 & 0xFF00 | EndianConverter.read(stream) << 16;
    }

    public static long read8ByteBlock(InputStream stream) throws IOException {
        return (long)(EndianConverter.read(stream) & 0xFF | EndianConverter.read(stream) << 8 & 0xFF00 | EndianConverter.read(stream) << 16 & 0xFF0000 | EndianConverter.read(stream) << 24 & 0xFF000000) | (long)(EndianConverter.read(stream) << 32) & 0xFF00000000L | (long)(EndianConverter.read(stream) << 40) & 0xFF0000000000L | (long)(EndianConverter.read(stream) << 48) & 0xFF000000000000L | (long)(EndianConverter.read(stream) << 56);
    }

    public static void writeLittleEndian(short[] srcBuffer, int srcOffset, int srcLength, OutputStream stream, byte[] tempBuffer) throws IOException {
        while (srcLength >= 0) {
            int processedData = EndianConverter.convertToLittleEndian(srcBuffer, tempBuffer, srcOffset, srcLength);
            stream.write(tempBuffer, 0, processedData * 2);
            srcOffset += processedData;
            srcLength -= processedData;
        }
    }

    public static void writeLittleEndian(int[] srcBuffer, int srcOffset, int srcLength, OutputStream stream, byte[] tempBuffer) throws IOException {
        while (srcLength > 0) {
            int processedData = EndianConverter.convertToLittleEndian(srcBuffer, tempBuffer, srcOffset, srcLength);
            stream.write(tempBuffer, 0, processedData * 4);
            srcOffset += processedData;
            srcLength -= processedData;
        }
    }

    public static void writeLittleEndian(long[] srcBuffer, int srcOffset, int srcLength, OutputStream stream, byte[] tempBuffer) throws IOException {
        while (srcLength > 0) {
            int processedData = EndianConverter.convertToLittleEndian(srcBuffer, tempBuffer, srcOffset, srcLength);
            stream.write(tempBuffer, 0, processedData * 8);
            srcOffset += processedData;
            srcLength -= processedData;
        }
    }

    public static void writeLittleEndian(int blockSize, int[] srcBuffer, int srcOffset, int srcLength, OutputStream stream, byte[] tempBuffer) throws IOException {
        while (srcLength > 0) {
            int processedData = EndianConverter.convertToLittleEndian(blockSize, srcBuffer, tempBuffer, srcOffset, srcLength);
            stream.write(tempBuffer, 0, processedData * blockSize);
            srcOffset += processedData;
            srcLength -= processedData;
        }
    }

    public static void writeLittleEndian(float[] srcBuffer, int srcOffset, int srcLength, OutputStream stream, byte[] tempBuffer) throws IOException {
        while (srcLength > 0) {
            int processedData = EndianConverter.convertToLittleEndian(srcBuffer, tempBuffer, srcOffset, srcLength);
            stream.write(tempBuffer, 0, processedData * 4);
            srcOffset += processedData;
            srcLength -= processedData;
        }
    }

    public static void writeLittleEndian(double[] srcBuffer, int srcOffset, int srcLength, OutputStream stream, byte[] tempBuffer) throws IOException {
        while (srcLength > 0) {
            int processedData = EndianConverter.convertToLittleEndian(srcBuffer, tempBuffer, srcOffset, srcLength);
            stream.write(tempBuffer, 0, processedData * 8);
            srcOffset += processedData;
            srcLength -= processedData;
        }
    }

    public static void writeLittleEndian(OutputStream stream, short value) throws IOException {
        stream.write(value);
        stream.write(value >> 8);
    }

    public static void writeLittleEndian(OutputStream stream, int value) throws IOException {
        stream.write(value);
        stream.write(value >> 8);
        stream.write(value >> 16);
        stream.write(value >> 24);
    }

    public static void writeLittleEndian(OutputStream stream, long value) throws IOException {
        for (int i = 0; i < 8; ++i) {
            stream.write((int)value);
            value >>= 8;
        }
    }

    private static int read2ByteBlock(byte[] readBuffer, int[] destBuffer, int destOffset, int destLength, InputStream stream, int mask) throws IOException {
        int numOfData;
        int numOfProcessedBytes;
        int numOfBytesRead = 0;
        int offset = 0;
        int length = readBuffer.length / 2 * 2;
        for (numOfData = 0; numOfBytesRead >= 0 && numOfData < destLength; numOfData += numOfProcessedBytes / 2) {
            int maxBytesToRead = Math.max((destLength - numOfData) * 2, length);
            numOfBytesRead = stream.read(readBuffer, offset, maxBytesToRead - offset);
            if (numOfBytesRead - (numOfProcessedBytes = EndianConverter.convert(2, readBuffer, destBuffer, numOfBytesRead + offset, destOffset + numOfData, destLength - numOfData, mask)) == 1) {
                offset = 1;
                readBuffer[0] = readBuffer[numOfProcessedBytes];
                continue;
            }
            offset = 0;
        }
        return numOfData;
    }

    private static int read3ByteBlock(byte[] readBuffer, int[] destBuffer, int destOffset, int destLength, InputStream stream, int mask) throws IOException {
        int numOfData;
        int numOfProcessedBytes;
        int numOfBytesRead = 0;
        int offset = 0;
        int length = readBuffer.length / 3 * 3;
        for (numOfData = 0; numOfBytesRead >= 0 && numOfData < destLength; numOfData += numOfProcessedBytes / 3) {
            int maxBytesToRead = Math.max((destLength - numOfData) * 3, length);
            numOfBytesRead = stream.read(readBuffer, offset, maxBytesToRead - offset);
            if ((offset = numOfBytesRead - (numOfProcessedBytes = EndianConverter.convert(3, readBuffer, destBuffer, numOfBytesRead + offset, destOffset + numOfData, destLength - numOfData, mask))) < 1) continue;
            readBuffer[0] = readBuffer[numOfProcessedBytes];
            if (offset < 2) continue;
            readBuffer[1] = readBuffer[numOfProcessedBytes + 1];
        }
        return numOfData;
    }

    private static int read(InputStream stream) throws IOException {
        int tempValue = stream.read();
        if (tempValue == -1) {
            throw new IOException("Filesize does not match blocksize");
        }
        return tempValue;
    }
}

