/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.preprocess;

import java.util.List;
import org.broad.igv.preprocess.Bin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinnedData {
    int zoomLevel;
    double binSize;
    private double meanCount;
    private double medianCount;
    private double maxCount;
    private double percentile10;
    private double percentile90;
    private int[] nPts;
    private List<? extends Bin> bins;
    private int[] tileBoundaries;

    public BinnedData(int zoomLevel, double binSize, List<? extends Bin> bins, int[] tileBoundaries) {
        this.zoomLevel = zoomLevel;
        this.binSize = binSize;
        this.bins = bins;
        this.tileBoundaries = tileBoundaries;
    }

    public int getZoomLevel() {
        return this.zoomLevel;
    }

    public List<? extends Bin> getBins() {
        return this.bins;
    }

    public int[] getLocations() {
        int[] locations = new int[this.bins.size()];
        for (int i = 0; i < this.bins.size(); ++i) {
            locations[i] = this.bins.get(i).getStart();
        }
        return locations;
    }

    public float[] getCounts() {
        float[] nPts = new float[this.bins.size()];
        for (int i = 0; i < this.bins.size(); ++i) {
            nPts[i] = this.bins.get(i).getFeatureCount();
        }
        return nPts;
    }

    public int[] getTileBoundaries() {
        return this.tileBoundaries;
    }

    public double getBinSize() {
        return this.binSize;
    }

    public double getMeanCount() {
        return this.meanCount;
    }

    public void setMeanCount(double meanCount) {
        this.meanCount = meanCount;
    }

    public double getMedianCount() {
        return this.medianCount;
    }

    public void setMedianCount(double medianCount) {
        this.medianCount = medianCount;
    }

    public double getMaxCount() {
        return this.maxCount;
    }

    public void setMaxCount(double maxCount) {
        this.maxCount = maxCount;
    }

    public double getPercentile90Count() {
        return this.percentile90;
    }

    public void setPercentile90(double percentile90) {
        this.percentile90 = percentile90;
    }

    public double getPercentile10() {
        return this.percentile10;
    }

    public void setPercentile10(double percentile10) {
        this.percentile10 = percentile10;
    }
}

