/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.preprocess;

import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.broad.igv.preprocess.AlignmentDataset;
import org.broad.igv.preprocess.ProcessingUtils;
import org.broad.igv.preprocess.ReadCounter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlignmentToWigConverter {
    static String usageString = "run_<platform>  inputDirectory  outputDirector genome [-m maskDirectory] [-w windowSize] [-ext extensionFactor] [-z maxZoomLevel] ";

    public static void main(String[] args) {
        File outputDir;
        if (args.length < 3) {
            System.out.println("Usage: " + usageString);
            System.exit(-1);
        }
        String inputDirectoryPath = args[0];
        String outputDirectoryPath = args[1];
        String genomeId = args[2];
        LinkedHashMap<String, String> argMap = ProcessingUtils.parseArgs(args, 3);
        File inputDirectory = new File(inputDirectoryPath);
        if (!inputDirectory.isDirectory()) {
            System.out.println(inputDirectory + " is not a directory");
            System.exit(-1);
        }
        if (!(outputDir = new File(outputDirectoryPath)).isDirectory()) {
            System.out.println(outputDir + " is not a directory");
            System.exit(-1);
        }
        String maskDirectory = (String)argMap.get("-m");
        int span = 25;
        String spanString = (String)argMap.get("-w");
        try {
            span = Integer.parseInt(spanString);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        int extensionFactor = 0;
        String extFactorString = (String)argMap.get("-ext");
        if (extFactorString != null) {
            try {
                extensionFactor = Integer.parseInt((String)argMap.get("-ext"));
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("Extension factor (-ext) must be an integer.");
                System.exit(-1);
            }
        }
        int maxZoom = 6;
        String maxZoomLevel = (String)argMap.get("-z");
        if (maxZoomLevel != null && maxZoomLevel.length() > 0) {
            try {
                maxZoom = Integer.parseInt(maxZoomLevel);
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println(numberFormatException.getMessage());
            }
        }
        boolean replaceExistingFiles = true;
        ReadCounter.Counts controlCounts = null;
        String controlFilename = (String)argMap.get("-c");
        File controlFile = null;
        if (controlFilename != null) {
            controlFile = controlFilename == null ? null : new File(inputDirectory, controlFilename);
            HashMap<String, Integer> ignore = new HashMap<String, Integer>();
            ReadCounter controlParser = new ReadCounter(controlFile);
            controlCounts = controlParser.doReadCounts(span, extensionFactor, genomeId, ignore);
        }
        for (File file : AlignmentToWigConverter.getInputFiles(inputDirectory)) {
            if (controlFile != null && file.equals(controlFile)) continue;
            try {
                System.out.println("Processing: " + file.getName());
                File outputFile = new File(outputDir, file.getName() + ".wig");
                if (!replaceExistingFiles && outputFile.exists()) continue;
                AlignmentToWigConverter.convertFile(file, outputFile, maskDirectory, genomeId, span, extensionFactor, controlCounts.countsPreChr);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static File[] getInputFiles(File sourceDirectory) {
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File dir, String fn) {
                return fn.endsWith(".aligned") || fn.endsWith("aligned.txt") || fn.endsWith(".realign") || fn.endsWith(".realign.txt");
            }
        };
        return sourceDirectory.listFiles(filter);
    }

    public static void convertFile(File inputFile, File outputFile, String maskDirectory, String genomeId, int span, int extensionFactor, Map<String, short[]> controlCounts) throws Exception {
        AlignmentDataset ds = new AlignmentDataset(inputFile, extensionFactor, maskDirectory, span, genomeId, controlCounts, false);
        PrintWriter writer = new PrintWriter(new FileWriter(outputFile));
        String h = ds.getDataHeadings()[0];
        for (String chr : ds.getChromosomes()) {
            int[] start = ds.getStartLocations(chr);
            float[] counts = ds.getData(h, chr);
            for (int i = 0; i < start.length; ++i) {
                if (i == 0 || start[i] != start[i - 1] + span) {
                    writer.println("fixedStep chrom=" + chr + " start=" + start[0] + " step=" + span + " span=" + span);
                }
                writer.println((int)counts[i]);
            }
        }
        writer.close();
    }
}

