/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.preprocess;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Random;
import org.broad.igv.feature.Chromosome;
import org.broad.igv.feature.Genome;
import org.broad.igv.feature.GenomeManager;

public class AlignmentTestFileGenerator {
    public static void main(String[] args) throws IOException {
        String genomeId = args.length > 0 ? args[0] : "hg18";
        AlignmentTestFileGenerator.generateTestFile(genomeId);
    }

    public static void generateTestFile(String genomeId) throws IOException {
        int step = 1000000;
        int width = 100000;
        int readLength = 50;
        Random r = new Random();
        PrintWriter pw = new PrintWriter(new FileWriter(genomeId + ".large.aligned.txt"));
        Genome genome = GenomeManager.getInstance().getGenome(genomeId);
        Chromosome[] chromosomes = genome.getChromosomes().toArray(new Chromosome[0]);
        int nAlignments = 50000000;
        for (int i = 0; i < nAlignments; ++i) {
            int cIdx = (int)(r.nextDouble() * 0.99 * (double)chromosomes.length);
            Chromosome c = chromosomes[cIdx];
            int peakIdx = (int)(r.nextDouble() * (double)c.getLength()) / step;
            int peak = peakIdx * step;
            int start = peak + (int)(r.nextGaussian() * (double)width);
            int end = start + readLength;
            if (start <= 0 || end >= c.getLength()) continue;
            String strand = r.nextBoolean() ? "-" : "+";
            pw.println(c.getName() + "\t" + start + "\t" + end + "\t" + strand);
        }
        pw.close();
    }
}

